<?php $__env->startSection('title', 'Users'); ?>


<?php $__env->startSection('content'); ?>

    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>
            <?php if($message = Session::get('success')): ?>
                <div class="alert alert-success alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong><?php echo e($message); ?></strong>
                </div>
            <?php endif; ?>
            <?php if($message = Session::get('delete')): ?>
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong><?php echo e($message); ?></strong>
                </div>
            <?php endif; ?>


            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create')): ?>
                            <a class="nav navbar-right" href="<?php echo e(route('users.create')); ?>">

                                <button type="button" class="btn btn-primary"><span class="glyphicon glyphicon-plus"
                                                                                    aria-hidden="true"></span>Create New
                                    User
                                </button>
                                
                                
                            </a>
                        <form action="<?php echo e(route('nmember.status')); ?>" method="post" id="myForm">
                            <input type="hidden" id="complaint_id" name="complaint_id">
                            <?php echo csrf_field(); ?>
                            <button class="nav navbar-right btn btn-info" id="save-c" style="margin-right:10px" type="button" >&nbsp;Click here to verify</button>
                        </form>
                            
                        <?php endif; ?>

                        <div class="x_title">
                            <h3>User Management</h3>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th><input type="checkbox" value="" class="master" name="select-all" id="select-all" /></th>
                                    <th>No</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Cnic#</th>
                                    <th>Cnic Front Image</th>
                                    <th>Cnic Back Image</th>
                                    <th>Tehsil</th>
                                    <th>District</th>
                                    <th>Union council</th>
                                    <th>Submission date</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><input type="checkbox" class="checkbox" value="<?php echo e($user->id); ?>" /></td>
                                        <td><?php echo e($user->id); ?></td>
                                        <td><?php echo e($user->name); ?></td>
                                        <td><?php echo e($user->email); ?></td>
                                        <td><?php echo e($user->id_no); ?></td>
                                        <td>
                                        <?php if($user->id_front!=''): ?>
                                        <a href="<?php echo e(asset('/assets/uploads/'.$user->id_front)); ?>" target="_blank"> <img alt="#" src="<?php echo e(asset('/assets/uploads/'.$user->id_front)); ?>" height="50px"
                                               width="50px"/></a>
                                        <?php endif; ?>
                                        </td>
                                        <td>
                                        <?php if($user->id_back!=''): ?>
                                        <a href="<?php echo e(asset('/assets/uploads/'.$user->id_back)); ?>" target="_blank"> <img alt="#" src="<?php echo e(asset('/assets/uploads/'.$user->id_back)); ?>" height="50px"
                                                 width="50px"/></a>
                                        <?php endif; ?>
                                        </td>
                                        <td><?php echo e($user->tehsil); ?></td>
                                        <td><?php echo e($user->district); ?></td>
                                        <td><?php echo e($user->union_council); ?></td>
                                        <td><?php echo e(date("l | dS F, Y g:i A",strtotime($user->create))); ?></td>
                                        <td>
                                            <a class="btn btn-info" href="<?php echo e(route('users.show',$user->id)); ?>">Show</a>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit')): ?>
                                                <a class="btn btn-primary"
                                                   href="<?php echo e(route('users.edit',$user->id)); ?>">Edit</a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete')): ?>
                                                <?php echo Form::open(['method' => 'DELETE','route' => ['users.destroy', $user->id],'style'=>'display:inline']); ?>

                                                <?php echo Form::submit('Delete', ['class' => 'btn btn-danger']); ?>

                                                <?php echo Form::close(); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function() {
    // Setup - add a text input to each footer cell
    $('#datatable1 thead tr').clone(true).appendTo( '#datatable1 thead' );
    $('#datatable1 thead tr:eq(1) th').each( function (i) {
        var title = $(this).text();
        $(this).html( '<input type="text" placeholder="Search '+title+'" />' );
 
        $( 'input', this ).on( 'keyup change', function () {
            if ( table.column(i).search() !== this.value ) {
                table
                    .column(i)
                    .search( this.value )
                    .draw();
            }
        } );
    } );
 
    var table = $('#datatable1').DataTable( {
        // orderCellsTop: true,
        columnDefs: [
            { orderable: false, targets: 0 }
          ],
        // fixedHeader: true
    } );
} );

$('#select-all').click(function(event) {   
    if(this.checked) {
        // Iterate each checkbox
        $(':checkbox').each(function() {
            this.checked = true;                        
        });
    } else {
        $(':checkbox').each(function() {
            this.checked = false;                       
        });
    }
});

$(function(){
    $('#save-c').click(function(){
        var val = [];
        $('.checkbox:checked').each(function(i){
            if($(this).val() != '' && $(this).val() != null){
                val[i] = $(this).val();
            }
        });
        
        if (val === undefined || val.length == 0) {
            alert('Select the complaint you want to veriy')
        }else{
            $('#complaint_id').val(val)
            $("#myForm").submit();
        }
        
        
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/eysbrpjn/public_html/pp67/resources/views/users/nmember.blade.php ENDPATH**/ ?>