<?php $__env->startSection('title', 'Complaint'); ?>


<?php $__env->startSection('content'); ?>

    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>

            <?php if($message = Session::get('success')): ?>
                <div class="alert alert-success alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong><?php echo e($message); ?></strong>
                </div>
            <?php endif; ?>
            <?php if($message = Session::get('delete')): ?>
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong><?php echo e($message); ?></strong>
                </div>
            <?php endif; ?>
            
            <div class="row mb-10">
                <div class="col-md-6">
                    <figure class="highcharts-figure">
                    <div id="container7"></div>
                    </figure>
                </div>
                <div class="col-md-6">
                    <figure class="highcharts-figure">
                    <div id="container8"></div>
                    </figure>
                </div>
            </div>
            <br>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create')): ?>
                            <a class="nav navbar-right" href="<?php echo e(route('dairy.create')); ?>">
                                <button type="button" class="btn btn-primary"><span class="glyphicon glyphicon-plus"
                                                                                    aria-hidden="true"></span>Create New
                                    Diary
                                </button>
                            </a>
                        <?php endif; ?>
                        <div class="x_title">
                            <h3>Diary Management</h3>
                            <div class="clearfix"></div>
                        </div>
                        <div class="toolbar" style="margin-bottom:10px">
                                <div class="row"> <div class="col-md-6">
                                     From <input name="min" class="form-control" id="min" type="date" value="0">
                                </div>
                                <div class="col-md-6">To <input name="max" class="form-control" id="max" type="date" value="0"></div>
                                </div>
                                
                                <div class="row"> 
                                    <div class="col-md-6">
                                        <select class="form-control" id="priority" style="margin-top:10px">
                                            <option value="">Select Priority</option>
                                                <?php $__currentLoopData = $priority; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($p); ?>"><?php echo e($p); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Priority</th>
                                    <th>Status</th>
                                    <th>Data</th>
                                    <th style="width: 250px">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($user->id); ?></td>
                                        <td><?php echo e($user->title); ?></td>
                                        <td><?php echo e($user->description); ?></td>
                                        <td>
                                        <?php if($user->image!=''): ?>
                                        <a href="<?php echo e(asset('/assets/uploads/'.$user->image)); ?>" target="_blank"> <img src="<?php echo e(asset('/assets/uploads/'.$user->image)); ?>" height="50px"
                                               class="img-thumbnail" alt="not found"  width="50px"/></a>
                                        <?php endif; ?>       
                                        </td>
                                        <td><?php echo e($user->priority); ?></td>
                                        <td><?php echo e($user->status); ?></td>
                                        <td> <?php echo e(date("l | dS F, Y g:i A",strtotime($user->date_time))); ?> </td>
                                        <td>
                                            <a class="btn btn-info"
                                               href="<?php echo e(route('dairy.show',$user->id)); ?>">Show</a>
                                             <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit')): ?>
                                              <a class="btn btn-warning"
                                                   href="<?php echo e(route('dairy.edit',$user->id)); ?>">Edit</a>
                                                <?php if($user->status != 'Complete'): ?>
                                                <a class="btn btn-primary showModal"
                                                   href="#" data-id="<?php echo e($user->id); ?>">Comment</a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete')): ?>
                                                <?php echo Form::open(['method' => 'DELETE','route' => ['dairy.destroy', $user->id],'style'=>'display:inline']); ?>

                                                <?php echo Form::submit('Remove Diary', ['class' => 'btn btn-danger']); ?>

                                                <?php echo Form::close(); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="exampleModalLabel">Comment Response</h4>
                    </div>
                    <div class="modal-body">
                        <?php echo Form::open(['method' => 'POST','accept-charset' => "UTF-8" ,'role' => 'form' ,
                           'enctype' => 'multipart/form-data' , 'data-parsley-validate' , 'id' => 'demo-form2',
                            'class' => 'form-horizontal form-label-left','route' => 'dairy.response']); ?>

 <?php echo csrf_field(); ?>
                        <input type="hidden" name="dairy_id" id="complaint_id" value="">
                       
                        
                        <!--<div class="form-group <?php echo e(($errors->has('status_id')) ? 'has-error' : ''); ?>">-->
                        <!--    <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Status <span-->
                        <!--            class="required">*</span>-->
                        <!--    </label>-->
                        <!--    <div class="col-md-6 col-sm-6 col-xs-12">-->
                        <!--        <?php echo Form::select('status_id',array('Pending' => 'Pending', 'Complete' => 'Complete'), 'Pending', array('class' => 'select2_single form-control col-md-7 col-xs-12','required' =>'required')); ?>-->
                        <!--    </div>-->
                        <!--    <?php echo ($errors->has('status_id') ? $errors->first('status_id', '<p class="text-danger">:message</p>') : ''); ?>-->
                        <!--</div>-->

                       
                        <div class="form-group <?php echo e(($errors->has('response')) ? 'has-error' : ''); ?>">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Response
                                <span
                                    class="required">*</span>
                            </label>
                            <div class="col-md-6 col-sm-6 col-xs-12">
                                <?php echo Form::textarea('response', null, array('placeholder' => 'Response','class' => 'form-control col-md-7 col-xs-12' , 'rows' => '3','required' =>'required')); ?>

                            </div>
                            <?php echo ($errors->has('response') ? $errors->first('response', '<p class="text-danger">:message</p>') : ''); ?>

                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
    <script>
    // $("div.toolbar").html('');

  $.fn.dataTable.ext.search.push(
    function(settings, data, dataIndex) {
      var min_date = document.getElementById("min").value;
      var min = new Date(min_date);
      var max_date = document.getElementById("max").value;
      var max = new Date(max_date);
      var p = document.getElementById("priority").value;
      
      
      var priority = data[4] || 0;
      var startDate = new Date(data[6]);
      
      
      
      
    
        // console.log('priority', priority);
        // console.log('p', p);
       
    //   console.log('min', min);
    //   console.log('max', max);
    //   console.log('startDate', startDate);
      //window.confirm(startDate);
      if (!min_date && !max_date) {
        return true;
      }
      if (!min_date  && startDate <= max ) {
        return true;
      }
      if (!max_date && startDate >= min) {
        return true;
      }
      if (startDate <= max && startDate >= min) {
        return true;
      }
      return false;
    }
  );

  var table = $('#datatable1').DataTable({
      "order": [[6, "desc"]]
  });

          // Event listener to the two range filtering inputs to redraw on input
          $('#min, #max').change(function() {
            table.draw();
          });
  
  
        $( '#priority' ).on( 'change', function () {
			if ( table.columns(4).search() !== $( '#priority' ).val() ) {
				table.columns(4).search( $( '#priority' ).val() ).draw();
			}
		} );
  
  
        $(document).ready(function () {
            $('.showModal').on('click', function () {
                var id = $(this).attr('data-id');
                console.log(id)
                $('#complaint_id').val(id)
                $('#exampleModal').modal('show');
            });

        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/eysbrpjn/public_html/pp67/resources/views/dairy/index.blade.php ENDPATH**/ ?>