@extends('layouts.app')


@section('content')

    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>

            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br><br>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Create New User</h2>
                            <div class="pull-right">
                                <a class="btn btn-primary" href="{{ route('users.index') }}"> Back</a>
                            </div>

                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <br/>
                            {!! Form::open(['method' => 'POST','accept-charset' => "UTF-8" ,'role' => 'form' ,
                            'enctype' => 'multipart/form-data' , 'data-parsley-validate' , 'id' => 'demo-form2',
                             'class' => 'form-horizontal form-label-left','route' => 'users.store']) !!}

                            <div class="form-group {{ ($errors->has('name')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Name <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control')) !!}
                                </div>
                                {!! ($errors->has('name') ? $errors->first('name', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('father_name')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Father name <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('father_name', null, array('placeholder' => 'Father Name','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('father_name') ? $errors->first('father_name', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            

                            <div class="form-group {{ ($errors->has('gender')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Gender <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::select('gender', ['Male','Female'], null,array('class' => 'select2_single form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('gender') ? $errors->first('gender', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('id_no')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">CNIC# <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('id_no', null, array('placeholder' => 'CNIC#','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('id_no') ? $errors->first('id_no', '<p class="text-danger">:message</p>') : '') !!}
                            </div>
                            
                            <div class="form-group {{ ($errors->has('dob')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Date of birth <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::date('dob', null, array('placeholder' => 'DOB','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('dob') ? $errors->first('dob', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('doe')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Date of expiry <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::date('doe', null, array('placeholder' => 'DOE','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('doe') ? $errors->first('doe', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('permanent_address')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Permanent address
                                    <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::textarea('permanent_address', null, array('placeholder' => 'Permanent address','class' => 'form-control col-md-7 col-xs-12' , 'rows' => '3')) !!}
                                </div>
                                {!! ($errors->has('permanent_address') ? $errors->first('permanent_address', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('mobile_no')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Mobile No <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('mobile_no', null, array('placeholder' => 'Mobile No','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('mobile_no') ? $errors->first('mobile_no', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('tehsil')) ? 'has-error' : '' }} hide">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Tehsil <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('tehsil', null, array('placeholder' => 'Tehsil','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('tehsil') ? $errors->first('tehsil', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('district')) ? 'has-error' : '' }} hide">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">District <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('district', null, array('placeholder' => 'District','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('district') ? $errors->first('district', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('union_council')) ? 'has-error' : '' }} hide">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Union council <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('union_council', null, array('placeholder' => 'Union council','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('union_council') ? $errors->first('union_council', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('disability')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Disability <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('disability', null, array('placeholder' => 'Disability','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('disability') ? $errors->first('disability', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('type_of_disability')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Type of disability
                                    <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('type_of_disability', null, array('placeholder' => 'Type of disability','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('type_of_disability') ? $errors->first('type_of_disability', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('police_station')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Police station <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('police_station', null, array('placeholder' => 'Police station','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('police_station') ? $errors->first('police_station', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('email')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Email <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('email', null, array('placeholder' => 'Email','class' => 'form-control')) !!}
                                </div>
                                {!! ($errors->has('email') ? $errors->first('email', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('password')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="password">Password <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::password('password', array('placeholder' => 'Password','class' => 'form-control')) !!}
                                </div>
                                {!! ($errors->has('password') ? $errors->first('password', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('confirm-password')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="confirm-password">Confirm
                                    password <span class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::password('confirm-password', array('placeholder' => 'Confirm password','class' => 'form-control')) !!}
                                </div>
                                {!! ($errors->has('confirm-password') ? $errors->first('confirm-password', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('roles')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Role <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::select('roles[]', $roles,[], array('class' => 'select2_single form-control')) !!}
                                </div>
                                {!! ($errors->has('roles') ? $errors->first('roles', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('recommended_by')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Recommended by <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::select('recommended_by', $users,null, array('class' => 'select2_single form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('recommended_by') ? $errors->first('recommended_by', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('photo')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Photo <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::file('photo',null, array('class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('photo') ? $errors->first('photo', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>

                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function () {
            $(".select2_single").select2({
                placeholder: "Select a option",
                allowClear: true
            });
        });
    </script>
@endsection
