@extends('layouts.app')
@section('content')
    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div> 
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2> Show Survey</h2>
                            <div class="pull-right">
                                <a class="btn btn-primary" href="{{ route('survey.index') }}"> Back</a>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <div class="row">
                                <div class="col-xs-12 col-sm-12 col-md-12">
                                    <div class="form-group">
                                        <strong>Title:</strong>
                                        {{ $survey->title }}
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-12 col-md-12">
                                    <div class="form-group">
                                        <strong>Description:</strong>
                                        {{ $survey->description }}
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-12 col-md-12">
                                    <div class="form-group">
                                        <strong>Status:</strong>
                                        {{ $survey->status }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row mb-10">
                <div class="col-md-12">
                 <figure class="highcharts-figure">
                <div id="container2"></div>
                <table id="datatable2" style="display:none">
                 <thead>
            <tr>
                <th></th>
                <th>Yes</th>
                <th>No</th>
            </tr>
        </thead>
                 <tbody>
            <tr>
                <th>Total Vote ({{ $survey->vote->count() }})</th>
                <td>{{ $yes }}</td>
                <td>{{ $no }}</td>
            </tr>
        </tbody>
                </table>
            </figure>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h1>Survey Vote</h1>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <!--<button type="button" class="btn btn-round btn-info">Total Vote - {{ $survey->vote->count() }}</button>-->
                            <!--<button type="button" class="btn btn-round btn-primary">Yes - {{ $yes }}</button>-->
                            <!--<button type="button" class="btn btn-round btn-success">No - {{ $no }}</button>-->
                            
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Vote</th>
                                    <th>Response By</th>
                                    <th>Created at</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($survey->vote as $key => $user)
                                    <tr>
                                        <td>{{ $user->id }}</td>
                                        <td>@if($user->vote == 1) Yes @else No @endif</td>
                                        <td>{{ $user->user->name }}</td>
                                        <td>{{ date("l | dS F, Y g:i A",strtotime($user->create)) }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            

        </div>
    </div>
@endsection

@section('script')

    <script>
Highcharts.chart('container2', {
    data: {
        table: 'datatable2'
    },
    chart: {
        type: 'column'
    },
    title: {
        text: 'Suvery Voting'
    },
    yAxis: {
        allowDecimals: false,
        title: {
            text: 'Number'
        }
    },
    tooltip: {
        formatter: function () {
            return '<b>' + this.series.name + '</b><br/>' +
                this.point.y + ' ' + this.point.name.toLowerCase();
        }
    }
});
        $(document).ready(function () {
            $('#datatable1').DataTable({
                "order": [[0, "desc"]]
            });
        });
    </script>
@endsection
