@extends('layouts.app')

@section('content')
    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>
            @if($message = Session::get('success'))
                <div class="alert alert-success alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            @if($message = Session::get('delete'))
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        @can('create')
                            <a class="nav navbar-right" href="{{ route('place.create') }}">
                                <button type="button" class="btn btn-primary">
                                    <span class="glyphicon glyphicon-plus" aria-hidden="true"></span>Create New
                                    Place
                                </button>
                            </a>
                        @endcan
                        <div class="x_title">
                            <h3> Manage Place</h3>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Place</th>
                                        <th>Union Council</th>
                                        <th>Police Station</th>
                                        <th>Tehsil</th>
                                        <th>Status</th>
                                        <th>Submission date</th>
                                        <th width="280px">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($data as $key => $d)
                                        <tr>
                                            <td>{{ $d->id }}</td>
                                            <td>{{ $d->place }}</td>
                                            <td>{{ $d->union_council }}</td>
                                            <td>{{ $d->police_station }}</td>
                                            <td>{{ $d->tehsil }}</td>
                                            <td>{{ $d->status }}</td>
                                            <td>{{ date("l | dS F, Y g:i A",strtotime($d->create)) }}</td>
                                            <td>
    {{--                                            <a class="btn btn-info" href="{{ route('place.show',$d->id) }}">Show</a>--}}
                                                @can('edit')
                                                    <a class="btn btn-primary"
                                                       href="{{ route('place.edit',$d->id) }}">Edit</a>
                                                @endcan
                                                @can('delete')
                                                    {!! Form::open(['method' => 'DELETE','route' => ['place.destroy', $d->id],'style'=>'display:inline']) !!}
                                                    {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                                    {!! Form::close() !!}
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
<script>
    $(document).ready(function () {
        $('#datatable1').DataTable({
            "order": [[0, "desc"]]
        });
    });
</script>
@endsection
