@extends('layouts.app')


@section('content')

    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>

            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br><br>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Edit Place</h2>
                            <div class="pull-right">
                                <a class="btn btn-primary" href="{{ route('place.index') }}"> Back</a>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <br/>
                            {!! Form::model($place, ['method' => 'PATCH','accept-charset' => "UTF-8" ,'role' => 'form' ,
                            'enctype' => 'multipart/form-data' , 'data-parsley-validate' , 'id' => 'demo-form2',
                             'class' => 'form-horizontal form-label-left','route' => ['place.update', $place->id]]) !!}
                            <div class="form-group {{ ($errors->has('title')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Place <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('place', null, array('placeholder' => 'Place','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('place') ? $errors->first('place', '<p class="text-danger">:message</p>') : '') !!}
                            </div>
                            
                            <div class="form-group {{ ($errors->has('union_council')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Union Council <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('union_council', null, array('placeholder' => 'Union Council','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('union_council') ? $errors->first('union_council', '<p class="text-danger">:message</p>') : '') !!}
                            </div>
                            
                            <div class="form-group {{ ($errors->has('police_station')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Police Station <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('police_station', null, array('placeholder' => 'Police Station','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('police_station') ? $errors->first('police_station', '<p class="text-danger">:message</p>') : '') !!}
                            </div>
                            
                            <div class="form-group {{ ($errors->has('tehsil')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Tehsil <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('tehsil', null, array('placeholder' => 'Tehsil','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('tehsil') ? $errors->first('tehsil', '<p class="text-danger">:message</p>') : '') !!}
                            </div>
                            
                            <div class="form-group {{ ($errors->has('status')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Status <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::select('status', ['Active' => 'Active','Disable'=>'Disable'], null,array('class' => 'select2_single form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('status') ? $errors->first('status', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>

                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function () {
            $(".select2_single").select2({
                placeholder: "Select Option",
                allowClear: true
            });
        });
    </script>
@endsection
