@extends('layouts.app')


@section('content')
    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Show Petition</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <div class="row">
                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Id:</strong>
                                        {{ $complaint->id }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Title:</strong>
                                        {{ $complaint->title }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Description:</strong>
                                        {{ $complaint->description }}
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Category:</strong>
                                        {{ $complaint->category->name }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Police station:</strong>
                                        {{ $complaint->police_station }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Teshil:</strong>
                                        {{ $complaint->tehsil }}
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>District:</strong>
                                        {{ $complaint->district }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Union Council:</strong>
                                        {{ $complaint->union_council }}
                                    </div>
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Status:</strong>
                                        {{ $complaint->status->name }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Complaint by:</strong>
                                        {{ $complaint->user->name }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row mb-10">
                <div class="col-md-12">
                 <figure class="highcharts-figure">
                <div id="container2"></div>
                <table id="datatable2" style="display:none">
                 <thead>
            <tr>
                <th></th>
                <th>Agreed</th>
            </tr>
        </thead>
                 <tbody>
            <tr>
                <th>Total Vote ({{ $complaint->vote->count() }})</th>
                <td>{{ $yes }}</td>
            </tr>
        </tbody>
                </table>
            </figure>
                </div>
            </div>
            
            <!--<div class="row">-->
            <!--    <div class="col-md-12">-->
            <!--        <div class="x_panel">-->
            <!--            <div class="x_content">-->
            <!--                <table id="datatable1" class="table table-striped table-bordered">-->
            <!--                    <thead>-->
            <!--                    <tr>-->
            <!--                        <th>No</th>-->
            <!--                        <th>Response</th>-->
            <!--                        <th>Response By</th>-->
            <!--                        <th>Created at</th>-->
            <!--                    </tr>-->
            <!--                    </thead>-->
            <!--                    <tbody>-->
            <!--                    @foreach ($complaint->response as $key => $user)-->
            <!--                        <tr>-->
            <!--                            <td>{{ $user->id }}</td>-->
            <!--                            <td>{{ $user->response }}</td>-->
            <!--                            <td>{{ $user->response_by }}</td>-->
            <!--                            <td>{{ $user->created_at }}</td>-->
            <!--                        </tr>-->
            <!--                    @endforeach-->
            <!--                    </tbody>-->
            <!--                </table>-->
            <!--            </div>-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
            <div class="row">
                <div class="col-md-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h4>Petition Vote</h4>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Vote</th>
                                    <th>Response By</th>
                                    <th>Created at</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($complaint->vote as $key => $user)
                                    <tr>
                                        <td>{{ $user->id }}</td>
                                        <td>@if($user->vote == 1) Yes @else No @endif</td>
                                        <td>{{ $user->user->name }}</td>
                                        <td>{{ $user->create }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')

    <script>
Highcharts.chart('container2', {
    data: {
        table: 'datatable2'
    },
    chart: {
        type: 'column'
    },
    title: {
        text: 'Petition Voting'
    },
    yAxis: {
        allowDecimals: false,
        title: {
            text: 'Number'
        }
    },
    tooltip: {
        formatter: function () {
            return '<b>' + this.series.name + '</b><br/>' +
                this.point.y + ' ' + this.point.name.toLowerCase();
        }
    }
});
        $(document).ready(function () {
            $('#datatable1').DataTable({
                "order": [[0, "desc"]]
            });
        });
    </script>
@endsection
