@extends('layouts.app')

@section('content')
    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>
            @if($message = Session::get('success'))
                <div class="alert alert-success alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            @if($message = Session::get('delete'))
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        @can('create')
                            <a class="nav navbar-right" href="{{ route('newfeed.create') }}">
                                <button type="button" class="btn btn-primary"><span class="glyphicon glyphicon-plus"
                                                                                    aria-hidden="true"></span>Create New
                                    New Feed
                                </button>
                            </a>
                        @endcan
                        <div class="x_title">
                            <h3>New Feed Management</h3>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Video</th>
                                    <th>Status</th>
                                    <th>Submission date</th>
                                    <th width="280px">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($data as $key => $d)
                                    <tr>
                                        <td>{{ $d->id }}</td>
                                        <td>{{ $d->title }}</td>
                                        <td>{{ $d->description }}</td>
                                        <td>
                                        @if($d->image!='')
                                        <a href="{{ asset('/assets/uploads/'.$d->image) }}" target="_blank">
                                                <img src="{{ asset('/assets/uploads/'.$d->image) }}" alt="no image" height="50px" width="50px"/></a>
                                         @endif
                                                </td>
                                        <td>
                                        @if($d->video!='')
                                            <a href="{{ asset('/assets/uploads/'.$d->video) }}" target="_blank">
                                                <video width="200" controls>
                                                    <source src="{{ asset('/assets/uploads/'.$d->video) }}" type="video/mp4">
                                                </video>
                                            </a>
                                        @endif 
                                        </td>
                                        <td>{{ $d->status }}</td>
                                        <td>{{ $d->create }}</td>
                                        <td>
                                            @if($d->status=='Active')
                                                <a data-toggle="tooltip" data-placement="bottom" title=""
                                                   data-original-title="Disable" class='btn btn-warning'
                                                   href="{{route('newfeed.disable',$d->id)}}">Disable</a>
                                            @elseif($d->status=='Disable')
                                                <a data-toggle="tooltip" data-placement="bottom" title=""
                                                   data-original-title="Activate" class='btn btn-success'
                                                   href="{{route('newfeed.activate',$d->id)}}">Activate</a>
                                            @endif
                                            @can('edit')
                                                <a class="btn btn-primary"
                                                   href="{{ route('newfeed.edit',$d->id) }}">Edit</a>
                                            @endcan
                                            @can('delete')
                                                {!! Form::open(['method' => 'DELETE','route' => ['newfeed.destroy', $d->id],'style'=>'display:inline']) !!}
                                                {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                                {!! Form::close() !!}
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
<script>
    $(document).ready(function () {
            $('#datatable1').DataTable({
                "order": [[0, "desc"]]
            });
    });
</script>
@endsection