@extends('layouts.app')

@section('content')
    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>
            @if($message = Session::get('success'))
                <div class="alert alert-success alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            @if($message = Session::get('delete'))
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        @can('create')
                            <a class="nav navbar-right" href="{{ route('memoir.create') }}">
                                <button type="button" class="btn btn-primary"><span class="glyphicon glyphicon-plus"
                                                                                    aria-hidden="true"></span>Create New
                                    Condolences
                                </button>
                            </a>
                        @endcan
                        <div class="x_title">
                            <h3> Condolences Management</h3>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Gallery Link</th>
                                    <th>Status</th>
                                    <th>Submission date</th>
                                    <th width="280px">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($data as $key => $d)
                                    <tr>
                                        <td>{{ $d->id }}</td>
                                        <td>{{ $d->title }}</td>
                                        <td>{{ $d->description }}</td>
                                        <td><a href="{{ asset('/assets/uploads/'.$d->image) }}" target="_blank"> <img src="{{asset('/assets/uploads/'.$d->image)}}" height="50px"
                                               class="img-thumbnail" alt="not found" width="50px"/></a></td>
                                        <td>{{ $d->gallery_link }}</td>
                                        <td>{{ $d->status }}</td>
                                        <td>{{ date("l | dS F, Y g:i A",strtotime($d->create)) }}</td>
                                        <td>
{{--                                            <a class="btn btn-info" href="{{ route('memoir.show',$d->id) }}">Show</a>--}}
                                            @can('edit')
                                                <a class="btn btn-primary"
                                                   href="{{ route('memoir.edit',$d->id) }}">Edit</a>
                                            @endcan
                                            @can('delete')
                                                {!! Form::open(['method' => 'DELETE','route' => ['memoir.destroy', $d->id],'style'=>'display:inline']) !!}
                                                {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                                {!! Form::close() !!}
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
<script>
    $(document).ready(function () {
            $('#datatable1').DataTable({
                "order": [[0, "desc"]]
            });
    });
</script>
@endsection
