@extends('layouts.app')


@section('content')

    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>

            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br><br>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Edit Condolences</h2>
                            <div class="pull-right">
                                <a class="btn btn-primary" href="{{ route('memoir.index') }}"> Back</a>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <br/>
                            {!! Form::model($memoir, ['method' => 'PATCH','accept-charset' => "UTF-8" ,'role' => 'form' ,
                            'enctype' => 'multipart/form-data' , 'data-parsley-validate' , 'id' => 'demo-form2',
                             'class' => 'form-horizontal form-label-left','route' => ['memoir.update', $memoir->id]]) !!}
                            <div class="form-group {{ ($errors->has('title')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Title <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('title', null, array('placeholder' => 'Title','required' => 'required','class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('title') ? $errors->first('title', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('description')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Description
                                    <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::textarea('description', null, array('placeholder' => 'Description','class' => 'form-control col-md-7 col-xs-12' , 'rows' => '3')) !!}
                                </div>
                                {!! ($errors->has('description') ? $errors->first('description', '<p class="text-danger">:message</p>') : '') !!}
                            </div>
                            
                            <div class="form-group {{ ($errors->has('image')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Image <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::file('image',null, array('class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('image') ? $errors->first('photo', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('status')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Status <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::select('status', ['Active' => 'Active','Disable'=>'Disable'], null,array('class' => 'select2_single form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('status') ? $errors->first('status', '<p class="text-danger">:message</p>') : '') !!}
                            </div>
                            
                            

                            <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>

                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function () {
            $(".select2_single").select2({
                placeholder: "Select Option",
                allowClear: true
            });
        });
    </script>
@endsection
