@extends('layouts.app')

@section('content')
    <div class="container">
        <div class="right_col" role="main" style="min-height: 304px;">

            <!-- top tiles -->
            <div class="row tile_count">
                <div class="animated flipInY col-md-2 col-sm-4 col-xs-4 tile_stats_count">
                    <div class="left"></div>
                    <div class="right">
                        <span class="count_top"><i class="fa fa-user"></i> Total Users</span>
                        <div class="count">{{$total_user}}</div>
                        <!--<span class="count_bottom"><i class="green">4% </i> From last Week</span>-->
                    </div>
                </div>
                <div class="animated flipInY col-md-2 col-sm-4 col-xs-4 tile_stats_count">
                    <div class="left"></div>
                    <div class="right">
                        <span class="count_top"><i class="fa fa-male"></i> Total Males</span>
                        <div class="count ">{{$user_male}}</div>
                        <!--<span class="count_bottom"><i class="green"><i class="fa fa-sort-asc"></i>34% </i> From last Week</span>-->
                    </div>
                </div>
                <div class="animated flipInY col-md-2 col-sm-4 col-xs-4 tile_stats_count">
                    <div class="left"></div>
                    <div class="right">
                        <span class="count_top"><i class="fa fa-female"></i> Total Females</span>
                        <div class="count">{{$user_female}}</div>
                        <!--<span class="count_bottom"><i class="red"><i class="fa fa-sort-desc"></i>12% </i> From last Week</span>-->
                    </div>
                </div>
                <div class="animated flipInY col-md-2 col-sm-4 col-xs-4 tile_stats_count">
                    <div class="left"></div>
                    <div class="right">
                        <span class="count_top"><i class="fa fa-ils"></i> Sub admin</span>
                        <div class="count">{{$subuser}}</div>
                        <!--<span class="count_bottom"><i class="green"><i class="fa fa-sort-asc"></i>34% </i> From last Week</span>-->
                    </div>
                </div>
                <div class="animated flipInY col-md-2 col-sm-4 col-xs-4 tile_stats_count">
                    <div class="left"></div>
                    <div class="right">
                        <span class="count_top"><i class="fa fa-circle"></i> Super user</span>
                        <div class="count">{{$superuser}}</div>
                        <!--<span class="count_bottom"><i class="green"><i class="fa fa-sort-asc"></i>34% </i> From last Week</span>-->
                    </div>
                </div>
                <div class="animated flipInY col-md-2 col-sm-4 col-xs-4 tile_stats_count">
                    <div class="left"></div>
                    <div class="right">
                        <span class="count_top"><i class="fa fa-ge"></i> Member</span>
                        <div class="count">{{ $member }}</div>
                        <!--<span class="count_bottom"><i class="green"><i class="fa fa-sort-asc"></i>34% </i> From last Week</span>-->
                    </div>
                </div>

            </div>
            <!-- /top tiles -->
            
            <br>
            <div class="row mb-10" style="display:none;">
                <div class="col-md-6">
                    <figure class="highcharts-figure">
                    <div id="container2"></div>
                    </figure>
                </div>
                <div class="col-md-6">
                    <figure class="highcharts-figure">
                    <div id="container3"></div>
                    </figure>
                </div>
            </div>
            <br>
            
            <div class="row mb-10" style="display:none;">
                <div class="col-md-6">
                    <figure class="highcharts-figure">
                    <div id="container7"></div>
                    </figure>
                </div>
                <div class="col-md-6">
                    <figure class="highcharts-figure">
                    <div id="container8"></div>
                    </figure>
                </div>
            </div>
            <br>
            
            <div class="row mb-10" style="display:none;">
                <div class="col-md-12">
                    <figure class="highcharts-figure">
                    <div id="container4"></div>
                    </figure>
                </div>
            </div>
            <br>
            
            <div class="row mb-10" style="display:none;">
                <div class="col-md-12">
                    <figure class="highcharts-figure">
                    <div id="container5"></div>
                    </figure>
                </div>
            </div>
            
            <div class="row mb-10" style="display:none;">
                <div class="col-md-12">
                    <figure class="highcharts-figure">
                    <div id="container6"></div>
                    </figure>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
<script>

Highcharts.chart('container8', {
    chart: {
        plotBackgroundColor: null,
        plotBorderWidth: null,
        plotShadow: false,
        type: 'pie'
    },
    title: {
        text: 'Complaint by status'
    },
    tooltip: {
        pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
    },
    accessibility: {
        point: {
            valueSuffix: ''
        }
    },
    plotOptions: {
        pie: {
            allowPointSelect: true,
            cursor: 'pointer',
            dataLabels: {
                enabled: false
            },
            showInLegend: true
        }
    },
    series: [{
        name: 'Status',
        colorByPoint: true,
        data: [
            <?php foreach($status as $s) { ?>
            {
                name: "<?php echo $s['id'] ?>",
                y: <?php echo $s['count'] ?>,
            },
            <?php } ?>
        ]
    }]
});

Highcharts.chart('container7', {
    chart: {
        plotBackgroundColor: null,
        plotBorderWidth: null,
        plotShadow: false,
        type: 'pie'
    },
    title: {
        text: 'Complaint by category'
    },
    tooltip: {
        pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
    },
    accessibility: {
        point: {
            valueSuffix: ''
        }
    },
    plotOptions: {
        pie: {
            allowPointSelect: true,
            cursor: 'pointer',
            dataLabels: {
                enabled: false
            },
            showInLegend: true
        }
    },
    series: [{
        name: 'Category',
        colorByPoint: true,
        data: [
            <?php foreach($catgory as $c) { ?>
            {
                name: "<?php echo $c['id'] ?>",
                y: <?php echo $c['count'] ?>,
            },
            <?php } ?>
            ]
    }]
});
    // Create the chart
Highcharts.chart('container4', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'District complaint by tehsil level'
    },
    subtitle: {
        text: 'District complaint by tehsil'
    },
    accessibility: {
        announceNewData: {
            enabled: true
        }
    },
    xAxis: {
        type: 'category'
    },
    yAxis: {
        title: {
            text: 'Number'
        }

    },
    legend: {
        enabled: false
    },
    plotOptions: {
        series: {
            borderWidth: 0,
            dataLabels: {
                enabled: true,
                format: '{point.y:.1f}'
            }
        }
    },

    tooltip: {
        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.2f}</b> of total<br/>'
    },

    series: [
        {
            name: "District",
            colorByPoint: true,
            data: [
                <?php foreach($district_complaint as $d_c){ ?>
                {
                    name: "<?php echo $d_c['district'] ?>",
                    y: <?php echo $d_c['count'] ?>,
                    drilldown: "<?php echo $d_c['district'] ?>"
                },
                
                <?php } ?>
            ]
        }
    ],
    drilldown: {
        series: [
            
            <?php foreach($district_complaint as $d_c){ ?>
                {
                    name: "<?php echo $d_c['district'] ?>",
                    id: "<?php echo $d_c['district'] ?>",
                    data: [
                        <?php foreach($d_c['data'] as $data){ ?> 
                        [
                            "<?php echo $data['name'] ?>",
                            <?php echo $data['count'] ?>,
                        ],
                        <?php } ?>
                    ]
                },
                
            <?php } ?>
        ]
    }
});

Highcharts.chart('container5', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'District complaint by union council'
    },
    subtitle: {
        text: 'District complaint by union council'
    },
    accessibility: {
        announceNewData: {
            enabled: true
        }
    },
    xAxis: {
        type: 'category'
    },
    yAxis: {
        title: {
            text: 'Number'
        }

    },
    legend: {
        enabled: false
    },
    plotOptions: {
        series: {
            borderWidth: 0,
            dataLabels: {
                enabled: true,
                format: '{point.y:.1f}'
            }
        }
    },

    tooltip: {
        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.2f}</b> of total<br/>'
    },

    series: [
        {
            name: "District",
            colorByPoint: true,
            data: [
                <?php foreach($union_council as $d_c){ ?>
                {
                    name: "<?php echo $d_c['district'] ?>",
                    y: <?php echo $d_c['count'] ?>,
                    drilldown: "<?php echo $d_c['district'] ?>"
                },
                
                <?php } ?>
            ]
        }
    ],
    drilldown: {
        series: [
            
            <?php foreach($union_council as $d_c){ ?>
                {
                    name: "<?php echo $d_c['district'] ?>",
                    id: "<?php echo $d_c['district'] ?>",
                    data: [
                        <?php foreach($d_c['data'] as $data){ ?> 
                        [
                            "<?php echo $data['name'] ?>",
                            <?php echo $data['count'] ?>,
                        ],
                        <?php } ?>
                    ]
                },
                
            <?php } ?>
        ]
    }
});

Highcharts.chart('container6', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'District complaint by police station'
    },
    subtitle: {
        text: 'District complaint by police station'
    },
    accessibility: {
        announceNewData: {
            enabled: true
        }
    },
    xAxis: {
        type: 'category'
    },
    yAxis: {
        title: {
            text: 'Number'
        }

    },
    legend: {
        enabled: false
    },
    plotOptions: {
        series: {
            borderWidth: 0,
            dataLabels: {
                enabled: true,
                format: '{point.y:.1f}'
            }
        }
    },

    tooltip: {
        headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
        pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.2f}</b> of total<br/>'
    },

    series: [
        {
            name: "District",
            colorByPoint: true,
            data: [
                <?php foreach($police_station as $d_c){ ?>
                {
                    name: "<?php echo $d_c['district'] ?>",
                    y: <?php echo $d_c['count'] ?>,
                    drilldown: "<?php echo $d_c['district'] ?>"
                },
                
                <?php } ?>
            ]
        }
    ],
    drilldown: {
        series: [
            
            <?php foreach($police_station as $d_c){ ?>
                {
                    name: "<?php echo $d_c['district'] ?>",
                    id: "<?php echo $d_c['district'] ?>",
                    data: [
                        <?php foreach($d_c['data'] as $data){ ?> 
                        [
                            "<?php echo $data['name'] ?>",
                            <?php echo $data['count'] ?>,
                        ],
                        <?php } ?>
                    ]
                },
                
            <?php } ?>
        ]
    }
});


Highcharts.chart('container2', {
    chart: {
        type: 'variablepie'
    },
    title: {
        text: 'Survey (<?php echo $survey ?>)'
    },
    tooltip: {
        headerFormat: '',
        pointFormat: '<span style="color:{point.color}">\u25CF</span> <b> {point.name}</b><br/>' +
            'Yes: <b>{point.y}</b><br/>' +
            'No: <b>{point.z}</b><br/>'
    },
    series: [{
        minPointSize: 10,
        innerSize: '20%',
        zMin: 0,
        name: 'countries',
        data: [
            
        <?php foreach($total_survey as $survey) { ?>
            {
                name: "<?php echo $survey['title'] ?>",
                y: <?php echo $survey['vote_yes'] ?>,
                z: <?php echo $survey['Vote_no'] ?>
            },
        <?php } ?>

            ]
    }]
});

Highcharts.chart('container3', {
    chart: {
        type: 'variablepie'
    },
    title: {
        text: "Petition (<?php echo $petition ?>)"
    },
    tooltip: {
        headerFormat: '',
        pointFormat: '<span style="color:{point.color}">\u25CF</span> <b> {point.name}</b><br/>' +
            'Aggreed: <b>{point.y}</b><br/>'
    },
    series: [{
        minPointSize: 10,
        innerSize: '20%',
        zMin: 0,
        name: 'countries',
        data: [
            
        <?php foreach($total_petition as $petition) { ?>
            {
                name: "<?php echo $petition['title'] ?>",
                y: <?php echo $petition['total_vote'] ?>,
            },
        <?php } ?>

            ]
    }]
});



$(document).ready(function () {
    $('#datatable1').DataTable({
        "order": [[0, "desc"]]
    });
});
</script>
@endsection
