@extends('layouts.app')



@section('content')

    <div class="right_col" role="main">

        <div class="">

            <div class="clearfix"></div>

            @if($message = Session::get('success'))

                <div class="alert alert-success alert-block">

                    <button type="button" class="close" data-dismiss="alert">

                    </button>

                    <strong>{{$message}}</strong>

                </div>

            @endif

            @if($message = Session::get('delete'))

                <div class="alert alert-danger alert-block">

                    <button type="button" class="close" data-dismiss="alert">

                    </button>

                    <strong>{{$message}}</strong>

                </div>

            @endif

            <div class="row">

                <div class="col-md-12 col-sm-12 col-xs-12">

                    <div class="x_panel">


                        <div class="x_title">

                            <h3>Support Management</h3>

                            <div class="clearfix"></div>

                        </div>

                        <div class="x_content">

                            <table id="datatable1" class="table table-striped table-bordered">

                                <thead>

                                <tr>

                                    <th>No</th>

                                    <th>Name</th>

                                    <th>Email</th>

                                    <th>Amount</th>

                                    <th>Status</th>

                                    <th>Date</th>

                                </tr>

                                </thead>

                                <tbody>

                                @foreach ($donation as $key => $d)

                                    <tr>

                                        <td>{{ $d->id }}</td>

                                        <td>{{ $d->name }}</td>

                                        <td>{{ $d->email }}</td>

                                        <td>{{ $d->amount }} £</td>
                                        <td>{{ $d->status }}</td>

                                        <td>{{ date("l | dS F, Y g:i A",strtotime($d->created_at)) }}</td>

                                        

                                    </tr>

                                @endforeach

                                </tbody>

                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

@endsection

@section('script')

<script>

    $(document).ready(function () {

            $('#datatable1').DataTable({

                "order": [[0, "desc"]]

            });

    });

</script>

@endsection