@extends('layouts.app')
@section('title', 'Contact Us')


@section('content')

    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>

            @if($message = Session::get('success'))
                <div class="alert alert-success alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            @if($message = Session::get('delete'))
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            
            <div class="row mb-10">
                <div class="col-md-6">
                    <figure class="highcharts-figure">
                    <div id="container7"></div>
                    </figure>
                </div>
                <div class="col-md-6">
                    <figure class="highcharts-figure">
                    <div id="container8"></div>
                    </figure>
                </div>
            </div>
            <br>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <!-- @can('create')
                            <a class="nav navbar-right" href="{{ route('dairy.create') }}">
                                <button type="button" class="btn btn-primary"><span class="glyphicon glyphicon-plus"
                                                                                    aria-hidden="true"></span>Create New
                                    Diary
                                </button>
                            </a>
                        @endcan -->
                        <div class="x_title">
                            <h3>Contact Us Management</h3>
                            <div class="clearfix"></div>
                        </div>
                        
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Message</th>
                                    <th>Device ID</th>
                                    <th>Date</th>
                                    <td>Delete</td>
                                    <th style="width: 150px">Status</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($data as $key => $contact)
                                    <tr>
                                        <td>{{ $contact->id }}</td>
                                        <td>{{ $contact->name }}</td>
                                        <td>{{ $contact->email }}</td>
                                        <td>{{ $contact->message }}</td>
                                       
                                        <td>{{ $contact->device_id }}</td>
                                        <td> {{ date("dS F, Y g:i A",strtotime($contact->created_at)) }} </td>
                                        <td>
                                            <form method="POST" action="{{ route('contactus.destroy', $contact->id) }}">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                            </form>
                                        </td>
                                        <td>
                                            <form method="POST" action="{{ route('contactus.store') }}">
                                                @csrf

                                                <input type="hidden" name="contact_id" value="{{ $contact->id }}">
                                                
                                                
                                                <select name="role" id="role" class="form-control role-dropdown" data-contact-id="{{ $contact->id }}">
                                                    <option value="" @if($contact->usertype == 'User') selected="selected" @endif >User</option>
                                                    <option value="Admin" @if($contact->usertype == 'Admin') selected="selected" @endif>Admin</option>
                                                
                                                </select>

                                                
                                            </form>

                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
           

    </div>
@endsection
@section('script')
<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function () {
        $('.role-dropdown').on('change', function () {
            var contactId = $(this).data('contact-id');
            var role = $(this).val();

            // Send AJAX request
            $.ajax({
                type: 'POST',
                url: '{{ route('contactus.store') }}',
                data: {
                    '_token': '{{ csrf_token() }}',
                    'contact_id': contactId,
                    'role': role,
                },
                success: function (data) {
                    // Handle success, e.g., show a success message
                    console.log('User assigned successfully');
                    console.log(data);
                },
                error: function (error) {
                    // Handle error, e.g., show an error message
                    console.error('Error assigning user:', error);
                }
            });
        });
    });
</script>









    <script>
    // $("div.toolbar").html('');

  $.fn.dataTable.ext.search.push(
    function(settings, data, dataIndex) {
      var min_date = document.getElementById("min").value;
      var min = new Date(min_date);
      var max_date = document.getElementById("max").value;
      var max = new Date(max_date);
      var p = document.getElementById("priority").value;
      
      
      var priority = data[4] || 0;
      var startDate = new Date(data[6]);
      
      
      
      
    
        // console.log('priority', priority);
        // console.log('p', p);
       
    //   console.log('min', min);
    //   console.log('max', max);
    //   console.log('startDate', startDate);
      //window.confirm(startDate);
      if (!min_date && !max_date) {
        return true;
      }
      if (!min_date  && startDate <= max ) {
        return true;
      }
      if (!max_date && startDate >= min) {
        return true;
      }
      if (startDate <= max && startDate >= min) {
        return true;
      }
      return false;
    }
  );

  var table = $('#datatable1').DataTable({
      "order": [[6, "desc"]]
  });

          // Event listener to the two range filtering inputs to redraw on input
          $('#min, #max').change(function() {
            table.draw();
          });
  
  
        $( '#priority' ).on( 'change', function () {
			if ( table.columns(4).search() !== $( '#priority' ).val() ) {
				table.columns(4).search( $( '#priority' ).val() ).draw();
			}
		} );
  
  
        $(document).ready(function () {
            $('.showModal').on('click', function () {
                var id = $(this).attr('data-id');
                console.log(id)
                $('#id').val(id)
                $('#exampleModal').modal('show');
            });

        });
    </script>
@endsection

