@extends('layouts.app')


@section('content')
    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Show Complaint</h2>
                            <br>
                            <a style="float:left;padding-left:20px;" href="{{ asset('/images/'.$complaint->photo) }}" target="_blank"> <img src="{{asset('/images/'.$complaint->photo)}}" width="50%"
                                               class="img-thumbnail" alt="not found" /></a>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <div class="row">
                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Id:</strong>
                                        {{ $complaint->id }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Title:</strong>
                                        {{ $complaint->title }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Description:</strong>
                                        {{ $complaint->description }}
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Category:</strong>
                                        {{ $complaint->category->name }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Police station:</strong>
                                        {{ $complaint->police_station }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Teshil:</strong>
                                        {{ $complaint->tehsil }}
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>District:</strong>
                                        {{ $complaint->district }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Union Council:</strong>
                                        {{ $complaint->union_council }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Priority:</strong>
                                        {{ $complaint->priority }}
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Status:</strong>
                                        {{ $complaint->status->name }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Sub Admin:</strong>
                                        {{ $complaint->subadmin->name }}
                                    </div>
                                </div>

                                <div class="col-xs-6 col-sm-6 col-md-4">
                                    <div class="form-group">
                                        <strong>Complaint by:</strong>
                                        {{ $complaint->user->name }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="x_panel">
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Response</th>
                                    <th>Evidence</th>
                                    <th>Response By</th>
                                    <th>Created at</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($complaint->response as $key => $user)
                                    <tr>
                                        <td>{{ $user->id }}</td>
                                        <td>{{ $user->response }}</td>
                                        <td><a href="{{ asset('/images/'.$user->photo) }}" target="_blank"> <img src="{{asset('/images/'.$user->photo)}}" height="50px"
                                                alt="not found" width="50px"/></a></td>
                                        <td>{{ $user->user->name }} ({{ $user->user->role }})</td>
                                        <td>{{ $user->create }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
