<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DairyResponse extends Model
{
    use HasFactory;
    
    protected $table ="dairy_responses";

    protected $fillable = [
        'user_by','response' ,'status_id','dairy_id'
    ];
    
    public function user()
    {
        return $this->belongsTo(User::class,'user_by','id')->withDefault();
    }
    
    public function getCreateAttribute()
    {
        return $this->created_at->format('d-m-Y h:i a');
    }
}
