<?php

namespace App\Http\Controllers;

use App\Models\NewFeed;
use App\Models\User;
use Illuminate\Http\Request;

class NewFeedController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:list|create|edit|delete', ['only' => ['index','show']]);
        $this->middleware('permission:create', ['only' => ['create','store']]);
        $this->middleware('permission:edit', ['only' => ['edit','update']]);
        $this->middleware('permission:delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $data = NewFeed::orderBy('id', 'DESC')->get();
        return view('newfeed.index',compact('data'));
//            ->with('i', (request()->input('page', 1) - 1) * 5);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create()
    {
        return view('newfeed.create');
    }

    public function store(Request $request)
    {
//        dd($request->all());
        request()->validate([
            'title' => 'required',
            'description' => 'required',
            'image' => 'mimes:jpeg,jpg,gif|max:2048',
            'video' => 'mimes:mp4,mov,ogg | max:20000',
        ]);

        $input = $request->all();

        if($request->image){
            $fileName = time().'.'.$request->image->extension();
            $request->image->move(public_path('assets/uploads'), $fileName);
            $input['image'] = $fileName;
        }

        if($request->video){
            $fileName1 = time().'.'.$request->video->extension();
            $request->video->move(public_path('assets/uploads'), $fileName1);
            $input['video'] = $fileName1;
        }

        $input['type'] = 2;
        $input['user_id'] = auth()->user()->id;
        $input['status'] = 'Active';
        $input['User Name'] = 'Sophia Naqvi';
        $input['profilephoto'] = 'sophia_naqvi.png';

        $data = NewFeed::create($input);
         NewFeed::where('id',$data->id)->update(['User Name'=>'Sophia Naqvi','profilephoto'=>'sophia_naqvi.png','status'=>'Active']);

        if($data){
            $token1 = '/topics/newsAndroid';
            $token = '/topics/news';
            $title = 'NewFeed';
            $body =  'SN has posted something new- You can share it now ';
            $click_action = 'NewFeed';
            $this->NotificationTopicSend($token1,$title,$body,$click_action,'android');
            $this->NotificationTopicSend($token,$title,$body,$click_action,'ios');
        }
        return redirect()->route('newfeed.index')
            ->with('success','New Feed created successfully.');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\NewFeed  $newfeed
     * @return \Illuminate\Http\Response
     */
    public function edit(NewFeed $newfeed)
    {
        return view('newfeed.edit',compact('newfeed'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\NewFeed  $newfeed
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, NewFeed $newfeed)
    {
        request()->validate([
            'title' => 'required',
            'description' => 'required',
            'image' => 'mimes:jpeg,jpg,gif|max:2048',
            'video' => 'mimes:mp4,mov,ogg | max:20000',
        ]);

        $input = $request->all();
        if($request->image){
            $fileName = time().'.'.$request->image->extension();
            $request->image->move(public_path('assets/uploads'), $fileName);
            $input['image'] = $fileName;
        }

        if($request->video){
            $fileName1 = time().'.'.$request->video->extension();
            $request->video->move(public_path('assets/uploads'), $fileName1);
            $input['video'] = $fileName1;
        }

        $input['user_id'] = auth()->user()->id;
        $newfeed->update($input);

        return redirect()->route('newfeed.index')
            ->with('success','New Feed updated successfully');
    }

    public function activate($id)
    {
        $update =  NewFeed::where('id', $id)->update(['status' => 'Active']);
        if($update){
            $notmp =  NewFeed::where('id', $id)->where('type',1)->first();
            if($notmp){
                $user = User::where('id',$notmp->user_id)->first();
                $token = $user->firebase_token;
                $device = $user->os;
                $title = 'Approved';
                $body =  'Your post has been approved. You can share it now';
                $click_action = 'NewFeed';
                $this->NotificationSend($token,$user->id,$title,$body,$click_action,$device);

                /////////////////////////////////////////////////////////////////////////
                $token1 = '/topics/news';
                $title1 = 'NewFeed';
                $body1 =  'Check your newsfeed now';
                $click_action1 = 'NewFeed';
                $token2 = '/topics/newsAndroid';
               $result1 =  $this->NotificationTopicSend($token2,$title1,$body1,$click_action1,'android');
               $result2 =  $this->NotificationTopicSend($token,$title1,$body1,$click_action1,'ios');


            }
        }
        return redirect()->route('newfeed.index')
            ->with('success','New Feed successfully activated');

    }

    public function disable($id)
    {
        // status update in User table
        NewFeed::where('id', $id)->update(['status' => 'Disable']);
        return redirect()->route('newfeed.index')
            ->with('success','New Feed successfully disabled');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\NewFeed  $newfeed
     * @return \Illuminate\Http\Response
     */
    public function destroy(NewFeed $newfeed)
    {
        $newfeed->delete();
        return redirect()->route('newfeed.index')
            ->with('success','New Feed deleted successfully');
    }


    public function sharenewsfeed($id)
    {
        $newfeed = NewFeed::where('id',$id)->first();
        return view('sharenewsfeed',['newfeed'=>$newfeed]);
        
    }

}
