<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Gallery;
class GalleryController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:list|create|edit|delete', ['only' => ['index','show']]);
        $this->middleware('permission:create', ['only' => ['create','store']]);
        $this->middleware('permission:edit', ['only' => ['edit','update']]);
        $this->middleware('permission:delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $data = Gallery::orderBy('id', 'DESC')->get();
        return view('gallery.index',compact('data'));
//            ->with('i', (request()->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create()
    {
        return view('gallery.create');
    }

    public function store(Request $request)
    {
//        dd($request->all());
        request()->validate([
            'images' => 'required|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        $input = $request->all();

        $fileName = time().'.'.$request->images->extension();
        $request->images->move(public_path('assets/uploads'), $fileName);
        $input['user_id'] = auth()->user()->id;
        $input['images'] = $fileName;
        $data = Gallery::create($input);

        if($data){
            $token = '/topics/news';
            $title = $request->title;
            $body =  $request->address;
            $click_action = 'Gallery';
            $token1 = '/topics/newsAndroid';
            $this->NotificationTopicSend($token1,$title,$body,$click_action,'android');
            $this->NotificationTopicSend($token,$title,$body,$click_action,'ios');
        }
        return redirect()->route('gallery.index')
            ->with('success','Gallery created successfully.');
    }

    public function destroy($id)
    {
        Gallery::find($id)->delete();
        return redirect()->route('gallery.index')
            ->with('success', 'Gallery deleted successfully');
    }
}
