<?php

namespace App\Http\Controllers;

use App\Models\Donation;
use Illuminate\Http\Request;
use Stripe;
use Session;


class DonationController extends Controller
{
    public function supportlist()
    {
        $donation = Donation::all();
        return view('donation.index',['donation'=>$donation]);
       
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       return view('support');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
        try {
            $result =  Stripe\Charge::create ([
                        "amount" => 100 * $request->amount,
                        "currency" => "GBP",
                        "source" => $request->stripeToken,
                        "description" => "Sophia Naqvi Support" 
                ]);
                $response = $result->jsonSerialize();
                $status = $response['status'];

                $donation = new Donation();
                $donation->name = $request->name;
                $donation->email = $request->email;
                $donation->amount = $request->amount;
                $donation->status = $status;
                $donation->save();

                if($status == 'succeeded')
                {
                    Session::flash('success', 'Payment successful!');
                }
                else
                {
                    Session::flash('error', 'Something went wrong! Try again later.');
                }
                    
                return back();
            }
            catch (\Exception $e) {
                // Handle Stripe payment error
                Session::flash('error', $e->getMessage());
                return redirect()->back();
            }
            
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Donation  $donation
     * @return \Illuminate\Http\Response
     */
    public function show(Donation $donation)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Donation  $donation
     * @return \Illuminate\Http\Response
     */
    public function edit(Donation $donation)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Donation  $donation
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Donation $donation)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Donation  $donation
     * @return \Illuminate\Http\Response
     */
    public function destroy(Donation $donation)
    {
        //
    }
}
