<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ContactUs;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class ContactUsController extends Controller
{
    public function index()
    {
        $data = ContactUs::orderBy('id','DESC')->get();
        return view('contactus.index',compact('data'));

    }

    public function store(Request $request)
    {
        $request->validate([
            'contact_id' => 'required',
            'role' => 'required',
        ]);
        $conact_info = ContactUs::findOrFail($request->input('contact_id'));
        if($conact_info->usertype == 'User')
        {
            $conact_info->usertype = 'Admin';
            $conact_info->save();
            $user = User::withTrashed()->where('email', $conact_info->email)->first();
            if($user)
            {
                $user->deleted_at = NULL;
                $user->save();
                return response()->json([
                    'message' => 'User role has been change into admin',
                    'status_code' => 200,
                ],200);
            }
            else
            {
                $user = User::create([
                    'name' => $conact_info->name,
                    'email' => $conact_info->email,
                    'password' => Hash::make('12345678'),
                    'role' => 'Admin',
                    'device_id' => $conact_info->device_id,
                    'status' => 3,
                ]);
                return response()->json([
                    'message' => 'User role has been change into admin',
                    'status_code' => 200,
                ],200);
            }
        }
        else
        {
            $del = User::where('email',$conact_info->email)->delete();
            $conact_info->usertype = 'User';
            $conact_info->save();
            return response()->json([
                'message' => 'Admin role has been change into User',
                'status_code' => 200,
            ],200);
        }










        if ($request->input('role') == 'Admin')
        {
           
            $user = User::create([
                'name' => $contact->name,
                'email' => $contact->email,
                'password' => Hash::make('12345678'),
                'role' => 'Admin',
                'device_id' => $contact->device_id,
                'status' => 3,
            ]);

        $contact->usertype = $request->input('role');
        $contact->save();
            

            // Send email to the user
            //Mail::to($user->email)->send(new RoleAssignedMail($user, 'admin'));

            // Redirect or respond as needed
            return redirect()->route('contactus.index')->with('success', 'Admin user created successfully!');
        } else {
            // If the role is not "admin," no action is performed
            return redirect()->route('contactus.index')->with('success', 'No action performed.');
        }
    }

    public function destroy($id)
    {
        // Find the contact record
        $contact = ContactUs::findOrFail($id);

        // Delete the record
        $contact->delete();

        // Redirect or respond as needed
        return redirect()->route('contactus.index')->with('success', 'Contact record deleted successfully!');
    }
}
