<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use App\Models\User;
use App\Models\Complaint;
use App\Models\Petition;
use App\Models\Announcement;
use App\Models\Survey;
use App\Models\SurveyVote;
use App\Models\Gallery;
use App\Models\NewFeed;
use App\Models\Memoir;
use App\Models\AboutMe;
use App\Models\PetitionVote;
use App\Models\ComplaintResponse;
use App\Models\NewsfeedLike;
use App\Models\Notification;
use App\Firebase;
use Spatie\Permission\Models\Role;
use App\Models\Category;
use App\Models\NewsfeedShare;
use App\Models\Place;
use App\Models\JoinTheFight;
use App\Models\Donation;
use App\Models\ContactUs;
use App\Models\Podcast;
use App\Models\PodcastMember;
use App\Classes\RtcTokenBuilder;
use App\Classes\RtmTokenBuilder;
use DateTimeZone;
use DateTime;
use Illuminate\Support\Str;


class ApiController extends Controller
{
   public function getPlaces(Request $request)
   {
        $query = Place::query();
        if($request->search) {
            $query->where('place','LIKE', "%$request->search%")
              ->orWhere('union_council','LIKE', "%$request->search%")
              ->orWhere('police_station','LIKE', "%$request->search%")
              ->orWhere('tehsil','LIKE', "%$request->search%");
        }
        $lists = $query->where('status','Active')->orderBy('id', 'desc')->paginate(200);
        return response()->json([
            'lists' => $lists,
            'message' => 'List Found',
            'status_code' => '200'
        ]);
   }
   public function category()
   {
        $check = Category::exists();
        if($check)
        {
			$list = Category::get(['id','name','urdu_name','image','created_at']);
            $totalpending = Complaint::where(['status_id'=>3,'user_id'=>Auth()->user()->id])->get()->count();
            $totalresolved = Complaint::where(['status_id'=>5,'user_id'=>Auth()->user()->id])->get()->count();
            $totalinreview = Complaint::where(['status_id'=>4,'user_id'=>Auth()->user()->id])->get()->count();
            $totalsubmitted = Complaint::where(['status_id'=>1,'user_id'=>Auth()->user()->id])->get()->count();
            $complaints = array(
                'totalpending' => $totalpending,
                'totlaresolved' => $totalresolved,
                'totalinreview' => $totalinreview,
                'totalsubmitted' => $totalsubmitted,
            );
            return response()->json([
                'message' => "Category display successfully",
                'status_code' => '200',
                'categories'  => $list,
                'img_url'     => asset('/assets/uploads/'),
                'complaints' => $complaints,
            ]);
        }
        else{
            return response()->json([
                'message' => "No Category found",
                'status_code' => '200',
            ]);
        }
    }
   public function signup(Request $request)
   {
       $validation = Validator::make($request->all(),[
           'mobile_no' => 'required',
           'email'     => 'required|email|max:255|unique:users',
           'password'  => 'required|min:6',
           'membertype' => 'required',
       ]);
       if($validation->fails())
       {
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
             'message' => $error,
              'status_code' => '400'
              ]);
       }
       $user = new User();
       $user->mobile_no = $request->mobile_no;
       $user->email = $request->email;
       $user->password = bcrypt($request->password);
       $vcode = mt_rand(1000,9999);
       $user->verificationcode = $vcode;
       $user->status = 4;
       $user->name = '';
       $user->membertype = $request->membertype;
       $user->stepcompletion = 1;
       if($user->save())
       {
        $data = array('verificationcode' => $vcode);
        $email = $request->email;
        Mail::send('verification', $data, function($message) use ($email){
            $message->to($email, evn('MAIL_FROM_NAME'))->subject
            ('Email Verification');
            $message->from(env('MAIL_FROM_ADDRESS'), evn('MAIL_FROM_NAME'));
        });
        return response()->json([
            'status_code' => '200',
            'message' => 'User has been register successfully',
            'user_id' => $user->id,
            'verificationcode' =>$vcode
        ]);
      }else{
        return response()->json([
            'message' => "Try Again",
            'status_code' => '400',
            'error' => 1
           ]);
      }
   }
   public function resendverificationcode(Request $request)
   {
       $userid = $request->user_id;//Auth()->user()->id;
       $user = User::where('id',$userid)->first();
       $email = $user->email;
       $vcode = mt_rand(1000,9999);
       $data = array('verificationcode' => $vcode);
       $user->verificationcode = $vcode;
       $user->save();
        Mail::send('verification', $data, function($message) use ($email){
            $message->to($email, evn('MAIL_FROM_NAME'))->subject
            ('Email Verification');
            $message->from(env('MAIL_FROM_ADDRESS'), evn('MAIL_FROM_NAME'));
        });
        return response()->json([
            'status_code' => '200',
            'message' => 'Verification code has been sent successfully',
            'user_id' => $user->id,
            'verificationcode' =>$vcode
        ]);
   }
   public function verificationcode(Request $request)
   {
       $validation = Validator::make($request->all(),[
           'verificationcode' => 'required',
           'user_id'         => 'required',
       ]);
       if($validation->fails()){
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
             'message' => $error,
              'status_code' => '400'
              ]);
       }
       $user = User::where('id',$request->user_id)->first();
       if($request->verificationcode == $user->verificationcode)
       {
            $user->status = 4;
            $user->stepcompletion = 2;
            $user->save();
            return response()->json([
                'status_code' => '200',
                'message' => 'Code has been verified successfully',
            ]);
       }
       else
       {
            return response()->json([
                'status_code' => '400',
                'message' => 'Code is invalid',
            ]);
       }
   }
   public function profileregistraion(Request $request)
    {
        $validation = Validator::make($request->all(),[
          'name' => 'required',
          'father_name' => 'required',
          'dob'   => 'required|date',
          'doe'  => 'required|date',
          'gender' => 'required',
          'id_no'  => 'required',
          'firebase_token'=> 'required',
          'device_id' => 'required',
          'user_id'  => 'required',
      ]);
      //'id_front'  => 'required',
     // 'id_back'   => 'required',
      if($validation->fails()){
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
             'message' => $error,
              'status_code' => '400'
              ]);
      }
      $user = User::where('id',$request->user_id)->first();
      $user->name = $request->name;
      $user->father_name = $request->father_name;
      $user->dob = $request->dob;
      $user->doe = $request->doe;
      $user->gender = $request->gender;
      $user->id_no = $request->id_no;
      $user->permanent_address = $request->permanent_address;
     // $user->mobile_no = $request->mobile_no;
      $user->tehsil = $request->tehsil;
      $user->district = $request->district;
      $user->union_council = $request->union_council;
      $user->disability = $request->disability;
      $user->type_of_disability = $request->type_of_disability;
      $user->police_station = $request->police_station;
      $user->firebase_token = $request->firebase_token;
      $user->countryofstay = $request->countryofstay;
      $user->current_address = $request->current_address;
      $user->super_user  = $request->super_user;
      $user->role = 'Member';
      $user->assignRole('Member');
      $user->device_id = $request->device_id;
      $user->token = '';
      if ($request->id_front) {
        $id_front = $request->id_front;
        $name = mt_rand(100000, 999999) . time() . '.' . $id_front->getClientOriginalExtension();
        $destinationPath = public_path('assets/uploads');
        $id_front->move($destinationPath, $name);
        $user->id_front = $name;
    }
    if ($request->id_back) {
        $id_back = $request->id_back;
        $name = mt_rand(100000, 999999) . time() . '.' . $id_back->getClientOriginalExtension();
        $destinationPath = public_path('assets/uploads');
        $id_back->move($destinationPath, $name);
        $user->id_back = $name;
    }
       if(!empty($request->recommended_by)){
          $user->recommended_by = $request->recommended_by;
        }
        else
        {
        $user->recommended_by = '0';
        }
       $user->stepcompletion = 3;
       $user->status = 4;
       if($user->save()){
            $email = $user->email;
            Mail::send('approval', [], function ($message) use ($email) {
                $message->to($email, evn('MAIL_FROM_NAME'))->subject
                ('Account Waiting Approval');
                $message->from(env('MAIL_FROM_ADDRESS'), evn('MAIL_FROM_NAME'));
            });
        //$token = $user->createToken('authToken')->plainTextToken;
        return response()->json([
            'status_code' => '200',
            'message' => 'Profile has been register successfully',
            'request' => $user
        ]);
        }
        else
        {
        return response()->json([
            'message' => "Try Again",
            'status_code' => '400',
            'error' => 1
           ]);
        }
    }
    public function uploadprofilepic(Request $request)
    {
        $validation = Validator::make($request->all(),[
            'image' => 'required',
        ]);
        if($validation->fails()){
          $error = $validation->errors()->first();
          return response()->json([
              'errors' => $validation->errors(),
               'message' => $error,
                'status_code' => '400'
                ]);
        }
        $user = User::where('id',Auth()->user()->id)->first();
        $user->photo = '';
        if ($request->image) {
            $images = $request->image;
            $name = mt_rand(100000, 999999) . time() . '.' . $images->getClientOriginalExtension();
            $destinationPath = public_path('assets/uploads');
            $images->move($destinationPath, $name);
            $user->photo = $name;
        }
        if($user->save()){
            return response()->json([
                'status_code' => '200',
                'message' => 'Profile Pic has been uploaded successfully',
                'request' => $user
            ]);
          }else{
            return response()->json([
                'message' => "Try Again",
                'status_code' => '400',
                'error' => 1
               ]);
          }
    }
    public function getprofilepic()
    {
        $user = User::where('id',Auth()->user()->id)->first();
        if($user->photo!='')
        {  return response()->json([
            'status_code' => '200',
            'image'    => $user->photo,
            'message' => 'Profile Pic has been displayed successfully',
        ]);
      }else{
        return response()->json([
            'message' => "Try Again",
            'status_code' => '400',
            'error' => 1
           ]);
      }
    }
    public function loginByCnic(Request $request)
    {
         $validation = Validator::make($request->all(),[
            'id_no' => 'required',
            'password' => 'required',
            'os' => 'required',
        ]);
        if($validation->fails()){
            $error = $validation->errors()->first();
            return response()->json([
                'errors' => $validation->errors(),
                 'message' => $error,
                  'status_code' => '400'
                  ]);
          }
          $credientials = request(['id_no','password']);
          if(!Auth::attempt($credientials))
          {
            return response()->json([
                'message' => "credentials are not correct",
                'error' => 1, 'status_code' => '400']);
          }
          $user = User::where(['id_no'=>$request->id_no])->first();
          $status = $user->status;
          Auth::user()->tokens->each(function($token, $key) {
            $token->delete();
            });
            $token = $user->createToken('authToken')->plainTextToken;
            $user->firebase_token = $request->firebase_token;
            $user->os = $request->os;
            $user->save();
            return response()->json(
                ['status_code'=>'200',
                'token'=> $token,
                'user' => $user,
                ]);
        //   if($status == 3)
        //   {
        //     Auth::user()->tokens->each(function($token, $key) {
        //         $token->delete();
        //     });
        //     $token = $user->createToken('authToken')->plainTextToken;
        //     $user->firebase_token = $request->firebase_token;
        //     $user->save();
        //       return response()->json(
        //           ['status_code'=>'200',
        //           'token'=> $token,
        //           'user' => $user,
        //         ]);
        //   }
        //   else
        //   {
        //     return response()->json(
        //         ['status_code'=>'400',
        //         'message'=> 'User is Verified',
        //         ]);
        //   }
    }
    public function loginByEmail(Request $request)
    {
        $validation = Validator::make($request->all(),[
            'email' => 'required|email',
            'password' => 'required',
            'os' => 'required',
        ]);
        if($validation->fails()){
            $error = $validation->errors()->first();
            return response()->json([
                'errors' => $validation->errors(),
                 'message' => $error,
                  'status_code' => '400'
                  ],400);
          }
          $credientials = request(['email','password']);
          if(!Auth::attempt($credientials))
          {
            return response()->json([
                'message' => "credentials are not correct",
                'error' => 1, 'status_code' => '400'],400);
          }
          $user = User::where(['email'=>$request->email])->first();
          $status = $user->status;
          Auth::user()->tokens->each(function($token, $key) {
            $token->delete();
            });
            $token = $user->createToken('authToken')->plainTextToken;
            $user->firebase_token = $request->firebase_token;
            $user->os = $request->os;
            $user->save();
            return response()->json(
                ['status_code'=>'200',
                'token'=> $token,
                'user' => $user,
                ]);
        //   if($status == 3)
        //   {
        //     Auth::user()->tokens->each(function($token, $key) {
        //         $token->delete();
        //     });
        //     $token = $user->createToken('authToken')->plainTextToken;
        //     $user->firebase_token = $request->firebase_token;
        //     $user->save();
        //       return response()->json(
        //           ['status_code'=>'200',
        //           'token'=> $token,
        //           'user' => $user,
        //         ]);
        //   }
        //   else
        //   {
        //     return response()->json(
        //         ['status_code'=>'400',
        //         'message'=> 'User is not verified',
        //         ]);
        //   }
    }
    public function logout(Request $request)
    {
        $check = Auth()->user()->currentAccessToken()->delete();
        if($check)
        {
            return response()->json([
                'message' => 'Token deleted successfully',
                'status_code' => '200',
            ]);
        }
        else
        {
            return response()->json([
                'message' => 'Try again later',
                'status_code' => '400',
                'error'      => 1,
            ]);
        }
    }
    function deleteuser(Request $request)
    {
        $validation = Validator::make($request->all(),[
            'user_id' => 'required',
        ]);
        if($validation->fails()){
            $error = $validation->errors()->first();
            return response()->json([
                'errors' => $validation->errors(),
                'message' => $error,
                'status_code' => '400'
                ]);
        }
        $del = User::where('id',$request->user_id)->delete();
        if($del)
        {
            return response()->json([
                'message' => "User has been deleted successfully",
                'status_code' => '200',
                ]);
        }
        else
        {
            return response()->json([
                'message' => "Some thing went wrong! Try again later.",
                'status_code' => '400'
                ]);
        }
    }
    public function profile()
    {
        $user_id = Auth()->user()->id;
        $uinfo = User::where(['id'=>$user_id])->first();
            return response()->json([
                'profile' => $uinfo,
                'message' => "Profile display successfully.",
                'status_code' => '200'
                ]);
    }
    public function profileUpdate(Request $request)
    {
        if($request->email!='')
        {
            $validation = Validator::make($request->all(),[
                'email' => 'required|email|max:255|unique:users,email,' . auth()->user()->id,
            ]);
            if($validation->fails()){
                $error = $validation->errors()->first();
                return response()->json([
                    'errors' => $validation->errors(),
                    'message' => $error,
                    'status_code' => '400'
                    ]);
            }
   		 }
        $user = User::where('id', auth()->user()->id)->first();
        if($request->has('name')){
            $user->name = $request->name;
        }
        if($request->has('email')){
            $user->email = $request->email;
        }
        if($request->has('father_name')){
            $user->father_name = $request->father_name;
        }
        if($request->has('dob')){
            $user->dob = $request->dob;
        }
        if($request->has('doe')){
            $user->doe = $request->doe;
        }
        if($request->has('gender')){
            $user->gender = $request->gender;
        }
        if($request->has('id_no')){
            $user->id_no = $request->id_no;
        }
        if($request->has('permanent_address')){
            $user->permanent_address = $request->permanent_address;
        }
        if($request->has('mobile_no')){
            $user->mobile_no = $request->mobile_no;
        }
        if($request->has('tehsil')){
            $user->tehsil = $request->tehsil;
        }
        if($request->has('district')){
            $user->district = $request->district;
        }
        if($request->has('union_council')){
            $user->union_council = $request->union_council;
        }
        if($request->has('disability')){
            $user->disability = $request->disability;
        }
        if($request->has('type_of_disability')){
            $user->type_of_disability = $request->type_of_disability;
        }
        if($request->has('police_station')){
            $user->police_station = $request->police_station;
        }
        if ($request->has('id_front')) {
            $id_front = $request->id_front;
            $name = mt_rand(100000, 999999) . time() . '.' . $id_front->getClientOriginalExtension();
            $destinationPath = public_path('assets/uploads');
            $id_front->move($destinationPath, $name);
            $user->id_front = $name;
        }
        if ($request->has('id_back')) {
            $id_back = $request->id_back;
            $name = mt_rand(100000, 999999) . time() . '.' . $id_back->getClientOriginalExtension();
            $destinationPath = public_path('assets/uploads');
            $id_back->move($destinationPath, $name);
            $user->id_back = $name;
        }
        if($user->save()){
            return response()->json([
                'status_code' => '200',
                'message' => 'Profile has been updated successfully',
                ]);
          }else{
            return response()->json([
                'message' => "Try Again",
                'status_code' => '400',
                'error' => 1
               ]);
          }
    }
    public function updatePassword(Request $request)
    {
        $user_id = Auth()->user()->id;
        $validation = Validator::make($request->all(),[
            'password' => 'required',
            'old_password'=>'required'
        ]);
        if($validation->fails()){
            $error = $validation->errors()->first();
            return response()->json([
                'errors' => $validation->errors(),
                'message' => $error,
                'status_code' => '400'
                ]);
        }
            $user = User::where('id',$user_id)->first();
            if (!Hash::check($request['old_password'], Auth::user()->password)) 
            {
                return response()->json([
                    'message' => "The Old password did not match",
                    'status_code' => '400',
                    'error' => 1
                ]);
            }
            $user->password = bcrypt($request->password);
            if($user->save())
            {
                return response()->json([
                    'status_code' => '200',
                    'message' => 'Password has been updated successfully',
                    'request' => $user
                ]);
            }else
            {
                return response()->json([
                    'message' => "Try Again",
                    'status_code' => '400',
                    'error' => 1
                ]);
            }
    }
    function generateRandomString($length = 10) {
        return substr(str_shuffle(str_repeat($x='0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length/strlen($x)) )),1,$length);
    }
    public function forgotPassword(Request $request)
    {
        if($request->email == 'ahmed@yopmail.com')
        {
            return response()->json([
                'message' => 'Email Sent Successfully',
                'status_code' => '200'
            ]);
        }
        else
        {
            if($request->email){
                $user = User::where('email',$request->email)->first();
                if(!empty($user))
                {
                    $hashed_random_password = $this->generateRandomString(6);
                    $password = $hashed_random_password;
                    $user->password = bcrypt($password);
                    $user->save();
                    $email = $request->email;
                    $data = array('password' => $password);
                    Mail::send('resetmail', $data, function($message) use ($email){
                        $message->to($email, evn('MAIL_FROM_NAME'))->subject
                        ('Reset Password');
                        $message->from(env('MAIL_FROM_ADDRESS'), evn('MAIL_FROM_NAME'));
                    });
                    if (Mail::failures()) {
                        return response()->json([
                            'message' => "Invalid Request",
                            'status_code' => '400',
                            'error' => 1
                        ]);
                    }
                    return response()->json([
                        'message' => 'Email Sent Successfully',
                        'status_code' => '200'
                    ]);
                }else{
                    return response()->json([
                        'message' => "User Not Found",
                        'status_code' => '400',
                        'error' => 1
                    ]);
                }
            }else{
                return response()->json([
                    'message' => "Invalid Request",
                    'status_code' => '400',
                    'error' => 1
                ]);
            }
        }
    }
    public function addComplaint(Request $request)
    {
        $validation = Validator::make($request->all(),[
            'title'          => 'required',
            'description'    => 'required',
            'category_id'    => 'required',
            'police_station' => 'required',
            'tehsil'         => 'required',
            'district'       => 'required',
            'union_council'  => 'required',
        ]);
        if($validation->fails()){
            $error = $validation->errors()->first();
            return response()->json([
                'errors' => $validation->errors(),
                 'message' => $error,
                  'status_code' => '400'
                  ]);
        }
        $complaint = new Complaint();
        $complaint->title = $request->title;
        $complaint->description = $request->description;
        $complaint->category_id = $request->category_id;
        $complaint->user_id = Auth()->user()->id;
        $complaint->status_id = 1;
        $complaint->police_station = $request->police_station;
        $complaint->tehsil = $request->tehsil;
        $complaint->district = $request->district;
        $complaint->union_council = $request->union_council;
        $photo = array();
        if($request->hasfile('image')) {
            foreach($request->file('image') as $file)
            {
                $name = mt_rand(100000, 999999) . time() . '.' . $file->getClientOriginalExtension();
                $destinationPath = public_path('assets/uploads');
                $file->move($destinationPath, $name);
                $photo[] = $name;
           }
        }
        // echo "<pre>"; print_r($photo); echo "</pre>";
        // echo "<pre>"; print_r(json_encode($photo)); echo "</pre>";
        // $test = json_encode($photo);
        // echo "<pre>"; print_r(json_decode($test)); echo "</pre>";
        // exit;
        $complaint->photo = json_encode($photo);
       if($complaint->save())
       {
        return response()->json([
            'message' => "Complaint has been registered successfully",
            'status_code' => '200',
        ]);
       }
       else
       {
        return response()->json([
            'message' => "Try Again",
            'status_code' => '400',
            'error' => 1
        ]);
       }
    }
    public function allComplaints()
    {
       // $user_id = Auth()->user()->id;
        $check = Complaint::select('*')->exists();
        if($check)
        {
            //$complaints = Complaint::where('user_id',$user_id)->get();
			$complaints = Complaint::join('users', 'complaints.user_id', '=', 'users.id')
				 ->leftjoin('categories', 'complaints.category_id', '=', 'categories.id')
				 ->leftjoin('status', 'complaints.status_id', '=', 'status.id')
                 ->orderBy('complaints.id','desc')->get(['complaints.*', 'users.name as User Name','categories.name as Category Name','status.name as status']);
            foreach($complaints as $key=>$val)
            {
               $photos=  json_decode($val->photo);
               $complaints[$key]['photos']= $photos;
            }
                return response()->json([
                'message' => "Complaints display successfully",
                'status_code' => '200',
                'complaints'  => $complaints,
            ]);
        }
        else{
            return response()->json([
                'message' => "No Complaint found",
                'status_code' => '200',
            ]);
        }
    }
    public function showComplaint(Request $request)
    {
      $list = Complaint::where(['id'=>$request->id])->get();
      $cresponses = DB::table('complaint_responses')->where('complaint_id',$request->id)->get();
      foreach($list as $key=>$val)
      {
         $photos=  json_decode($val->photo);
         $list[$key]['photos']= $photos;
      }
      return response()->json(
        ['status_code'=>'200',
        'complaints'=>  $list,
        'complaint Responses' => $cresponses,
        ]);
    }
    public function allcomplaintstatus()
    {
            $totalpending = Complaint::where(['status_id'=>3])->get()->count();
            $totalresolved = Complaint::where(['status_id'=>5])->get()->count();
            $totalinreview = Complaint::where(['status_id'=>4])->get()->count();
            $totalsubmitted = Complaint::where(['status_id'=>1])->get()->count();
               return response()->json(
                ['status_code'=>'200',
                'totalpending'=>  $totalpending,
                'totalresolved'=>  $totalresolved,
                'totalinreview'=>  $totalinreview,
                'totalsubmitted'=>  $totalsubmitted,
                 ]);
    }
    public function submittedcomplaints(Request $request)
    {
        $userid = Auth()->user()->id;
        $check = Complaint::where(['status_id'=>1,'user_id'=>$userid])->exists();
        if($check){
            $totalpending = Complaint::where(['status_id'=>3])->get()->count();
            $totalresolved = Complaint::where(['status_id'=>5])->get()->count();
            $totalinreview = Complaint::where(['status_id'=>4])->get()->count();
            $totalsubmitted = Complaint::where(['status_id'=>1])->get()->count();
			$complaints = Complaint::where(['status_id'=>1,'user_id'=>$userid])
			   ->join('categories', 'complaints.category_id', '=', 'categories.id')
			   ->join('status', 'complaints.status_id', '=', 'status.id')
			   ->join('users', 'complaints.user_id', '=', 'users.id')
			   ->orderBy('complaints.id','desc')->get(['complaints.*', 'categories.name as Category Name','status.name as status', 'users.name as User Name']);
               foreach($complaints as $key=>$val)
               {
                  $photos=  json_decode($val->photo);
                  $complaints[$key]['photos']= $photos;
               }
               return response()->json(
                ['status_code'=>'200',
                'totalpending'=>  $totalpending,
                'totalresolved'=>  $totalresolved,
                'totalinreview'=>  $totalinreview,
                'totalsubmitted'=>  $totalsubmitted,
				'complaints'  => $complaints,
                 ]);
        }else{
            return response()->json(
                ['status_code'=>'200',
                'totalsubmitted'=>  0,
                 ]);
        }
    }
    public function pendingcomplaints(Request $request)
    {
        $userid = Auth()->user()->id;
        $check = Complaint::where(['status_id'=>3,'user_id'=> $userid])->exists();
        if($check){
            $totalpending = Complaint::where(['status_id'=>3])->get()->count();
            $totalresolved = Complaint::where(['status_id'=>5])->get()->count();
            $totalinreview = Complaint::where(['status_id'=>4])->get()->count();
            $totalsubmitted = Complaint::where(['status_id'=>1])->get()->count();
			$complaints = Complaint::where(['status_id'=>3,'user_id'=> $userid])
			   ->join('categories', 'complaints.category_id', '=', 'categories.id')
			   ->join('status', 'complaints.status_id', '=', 'status.id')
			   ->join('users', 'complaints.user_id', '=', 'users.id')
			   ->orderBy('complaints.id','desc')->get(['complaints.*', 'categories.name as Category Name','status.name as status', 'users.name as User Name']);
               foreach($complaints as $key=>$val)
               {
                  $photos=  json_decode($val->photo);
                  $complaints[$key]['photos']= $photos;
               }
            return response()->json(
                ['status_code'=>'200',
                'totalpending'=>  $totalpending,
                'totalresolved'=>  $totalresolved,
                'totalinreview'=>  $totalinreview,
                'totalsubmitted'=>  $totalsubmitted,
				'complaints'  => $complaints,
                 ]);
        }else{
            return response()->json(
                ['status_code'=>'200',
                'totalpending'=>  0,
                 ]);
        }
    }
    public function resolvedcomplaints(Request $request)
    {
        $userid = Auth()->user()->id;
        $check = Complaint::where(['status_id'=>5,'user_id'=> $userid])->exists();
        if($check){
            $totalpending = Complaint::where(['status_id'=>3])->get()->count();
            $totalresolved = Complaint::where(['status_id'=>5])->get()->count();
            $totalinreview = Complaint::where(['status_id'=>4])->get()->count();
            $totalsubmitted = Complaint::where(['status_id'=>1])->get()->count();
			$complaints = Complaint::where(['status_id'=>5,'user_id'=> $userid])
			   ->leftjoin('categories', 'complaints.category_id', '=', 'categories.id')
			   ->leftjoin('status', 'complaints.status_id', '=', 'status.id')
			   ->leftjoin('users', 'complaints.user_id', '=', 'users.id')
			   ->orderBy('complaints.id','desc')->get(['complaints.*', 'categories.name as Category Name','status.name as status', 'users.name as User Name']);
               foreach($complaints as $key=>$val)
               {
                  $photos=  json_decode($val->photo);
                  $complaints[$key]['photos']= $photos;
               }
               return response()->json(
                ['status_code'=>'200',
                'totalpending'=>  $totalpending,
                'totalresolved'=>  $totalresolved,
                'totalinreview'=>  $totalinreview,
                'totalsubmitted'=>  $totalsubmitted,
				'complaints'  => $complaints,
                 ]);
        }else{
            return response()->json(
                ['status_code'=>'200',
                'totalresolved'=>  0,
                 ]);
        }
    }
    public function inreviewcomplaints(Request $request)
    {
        $userid = Auth()->user()->id;
        $check = Complaint::where(['status_id'=>4,'user_id'=>$userid])->exists();
        if($check){
            $totalpending = Complaint::where(['status_id'=>3])->get()->count();
            $totalresolved = Complaint::where(['status_id'=>5])->get()->count();
            $totalinreview = Complaint::where(['status_id'=>4])->get()->count();
            $totalsubmitted = Complaint::where(['status_id'=>1])->get()->count();
			$complaints = Complaint::where(['status_id'=>4,'user_id'=>$userid])
			   ->leftjoin('categories', 'complaints.category_id', '=', 'categories.id')
			   ->leftjoin('status', 'complaints.status_id', '=', 'status.id')
			   ->leftjoin('users', 'complaints.user_id', '=', 'users.id')
			   ->orderBy('complaints.id','desc')->get(['complaints.*', 'categories.name as Category Name','status.name as status', 'users.name as User Name']);
               foreach($complaints as $key=>$val)
               {
                  $photos=  json_decode($val->photo);
                  $complaints[$key]['photos']= $photos;
               }
               return response()->json(
                ['status_code'=>'200',
                'totalpending'=>  $totalpending,
                'totalresolved'=>  $totalresolved,
                'totalinreview'=>  $totalinreview,
                'totalsubmitted'=>  $totalsubmitted,
				'complaints'  => $complaints,
                 ]);
        }else{
            return response()->json(
                ['status_code'=>'200',
                'totalinreview'=>  0,
                 ]);
        }
    }
    public function getComplaintResponse(Request $request)
    {
        $comp_id = $request->id;
        $check = ComplaintResponse::where('complaint_id',$comp_id)->exists();
        if($check)
        {
            $responses = ComplaintResponse::where('complaint_id',$comp_id)
                      ->leftjoin('users', 'complaint_responses.response_by', '=', 'users.id')
                      ->orderBy('complaint_responses.id','desc')->get(['complaint_responses.*', 'users.name as User Name'
                      ,'users.photo as profilephoto']);
            foreach($responses as $key=>$val)
            {
                $photos=  json_decode($val->photo);
                $responses[$key]['photos']= $photos;
            }
            return response()->json(
                ['status_code'=>'200',
                'responses'=>  $responses,
				]);
        }
        else{
            return response()->json(
                ['status_code'=>'400',
                'message'=>  'No Response found',
                 ]);
        }
    }
    public function addcomplaintresponse(Request $request)
    {
        $validation = Validator::make($request->all(),[
            'response' => 'required',
            'complaint_id' => 'required',
        ]);
        if($validation->fails()){
            $error = $validation->errors()->first();
            return response()->json([
                'errors' => $validation->errors(),
                 'message' => $error,
                  'status_code' => '400'
                  ]);
          }
          $compresponse = new ComplaintResponse();
          $compresponse->response = $request->response;
          $compresponse->response_by = Auth()->user()->id;
          $compresponse->complaint_id = $request->complaint_id;
          $photo = array();
          if($request->hasfile('image'))
           {
              foreach($request->file('image') as $file)
              {
                  $name = mt_rand(100000, 999999) . time() . '.' . $file->getClientOriginalExtension();
                  $destinationPath = public_path('assets/uploads');
                  $file->move($destinationPath, $name);
                  $photo[] = $name;
              }
           }
           $compresponse->photo = json_encode($photo);
           if($compresponse->save())
            {
                $com = Complaint::where('id',$request->complaint_id)->first();
                $email = $com->subadmin->email;
                Mail::send('complaint_assign', [], function ($message) use ($email) {
                    $message->to($email, evn('MAIL_FROM_NAME'))->subject
                    ('Submit Response');
                    $message->from(env('MAIL_FROM_ADDRESS'), evn('MAIL_FROM_NAME'));
                });
                return response()->json([
                    'message' => "Complaint Response has been added successfully",
                    'status_code' => '200',
                ]);
            }
            else
            {
                return response()->json([
                    'message' => "Try Again",
                    'status_code' => '400',
                    'error' => 1
                ]);
            }
    }
    public function addPetition(Request $request)
    {
        $validation = Validator::make($request->all(),[
            'title'          => 'required',
            'description'    => 'required',
            'police_station' => 'required',
            'tehsil'         => 'required',
            'union_council'  => 'required',
        ]);
		//'category_id'    => 'required',
		//'district'       => 'required',
        if($validation->fails()){
            $error = $validation->errors()->first();
            return response()->json([
                'errors' => $validation->errors(),
                 'message' => $error,
                  'status_code' => '400'
                  ]);
        }
        $petition =new Petition();
        $petition->title = $request->title;
        $petition->description = $request->description;
        $petition->category_id = $request->category_id;
        $petition->user_id = Auth()->user()->id;
        $petition->status_id = 3;
        $petition->police_station = $request->police_station;
        $petition->tehsil  = $request->tehsil;
        $petition->district = $request->district;
        $petition->union_council= $request->union_council;
        $photo = array();
        if($request->hasfile('image')) {
            foreach($request->file('image') as $file)
            {
                $name = mt_rand(100000, 999999) . time() . '.' . $file->getClientOriginalExtension();
                $destinationPath = public_path('assets/uploads');
                $file->move($destinationPath, $name);
                $photo[] = $name;
           }
        }
        $petition->photo = json_encode($photo);
        if($petition->save())
        {
            return response()->json([
                'message' => "Petition has been registered successfully",
                'status_code' => '200',
            ]);
        }
        else
        {
            return response()->json([
                'message' => "Try Again",
                'status_code' => '400',
                'error' => 1
            ]);
        }
    }
    public function allPetitions()
    {
        $user_id = Auth()->user()->id;
        $check = Petition::where('status_id',1)->exists();
        if($check)
        {
			$list = Petition::join('users', 'petitions.user_id', '=', 'users.id')
				// ->join('categories', 'petitions.category_id', '=', 'categories.id')
                 ->leftjoin('status', 'petitions.status_id', '=', 'status.id')
                 ->leftjoin("petition_votes",function($join){
                    $join->on("petition_votes.petition_id","=","petitions.id");
                    $join->where("petition_votes.user_id","=", Auth()->user()->id);
                })
                ->where('petitions.status_id', '1')
                ->orderBy('petitions.vote_yes', 'DESC')
               ->get(['petitions.*', 'users.name as User Name','status.name as status',
               'petition_votes.vote as agreedvote'
            ]);
            foreach($list as $key=>$val)
            {
               $photos=  json_decode($val->photo);
               $list[$key]['photos']= $photos;
            }
            //$petitions = Petition::where('status_id',1)->get();
            return response()->json([
                'message' => "Petitions display successfully",
                'status_code' => '200',
                'petitions'  => $list
            ]);
        }
        else{
            return response()->json([
                'message' => "No Petition found",
                'status_code' => '200',
                'petitions' => [],
            ]);
        }
    }
    public function showPetition(Request $request)
    {
        $check  = Petition::where(['id'=>$request->id])->exists();
		if($check)
		{
			$list2 = Petition::join('users', 'petitions.user_id', '=', 'users.id')
			  ->where(['petitions.id'=>$request->id])
			  ->get(['petitions.*', 'users.name as User Name']);
               foreach($list2 as $key=>$val)
               {
                  $photos=  json_decode($val->photo);
                  $list2[$key]['photos']= $photos;
               }
			return response()->json(
			['status_code'=>'200',
			'Petition'=>  $list2,
			]);
		}
		else
		{
			return response()->json(
                ['status_code'=>'400',
                'message'=>  'No Petition found',
                ]);
		}
    }
    public function petitionvote()
    {
        $check = Petition::where('status_id','1')->exists();
        if($check){
            $votes = Petition::where('status_id','1')->get();
            return response()->json(
                ['status_code'=>'200',
                'Petition Votes'=>  $votes,
            ]);
        }else{
            return response()->json(
                ['status_code'=>'200',
                'message'=>  'No petitions found',
                ]);
        }
    }
    public function agreepetition(Request $request)
    {
        $id = $request->id;
        $validation = Validator::make($request->all(),[
            'id' => 'required'
        ]);
        if($validation->fails()){
            $error = $validation->errors()->first();
            return response()->json([
                'errors' => $validation->errors(),
                'message' => $error,
                'status_code' => '400'
            ]);
        }
        $uid = Auth()->user()->id;
        $check = PetitionVote::where(['petition_id'=>$id,"user_id"=>$uid])->exists();
        if($check){
            return response()->json([
                'message' => "You have already agreed this petition",
                'status_code' => '400',
                'error' => 1
            ]);
        }
        else{
            $petition = Petition::find($id);
            if($petition->user_id  != Auth()->user()->id){
                $petition->increment('vote_yes');
                if($petition->save()){
                        $pvote = new PetitionVote();
                        $pvote->petition_id = $id;
                        $pvote->user_id = $uid;
                        $pvote->vote = 1;
                        $pvote->save();
                        if($pvote){
                            $petition_user = Petition::where('id',$id)->first();
                            $user  = User::where('id',$petition_user['user_id'])->first();
                            $token = $user->firebase_token;
                            $device = $user->os;
                            $title = 'Agreed';
                            $body  =  Auth()->user()->name.' agreed your petition';
                            $click_action = 'Petition';
                            $this->NotificationSend($token,$user->id,$title,$body,$click_action,$device);
                        }
                        return response()->json([
                            'status_code' => '200',
                            'message' => 'Vote has been added successfully',
                        ]);
                }else{
                    return response()->json([
                        'message' => "Try Again",
                        'status_code' => '400',
                        'error' => 1
                    ]);
                }
            }
                else{
                    return response()->json([
                        'message' => "You cab't agree your own petition",
                        'status_code' => '400',
                        'error' => 1
                    ]);
            }
        }
    }
    public function withdrawmysupport(Request $request)
    {
        $id = $request->id;
        $validation = Validator::make($request->all(),[
            'id' => 'required'
        ]);
        if($validation->fails()){
            $error = $validation->errors()->first();
            return response()->json([
                'errors' => $validation->errors(),
                'message' => $error,
                'status_code' => '400'
                ]);
        }
        $userid = Auth()->user()->id;
        $petionexit = PetitionVote::where(['petition_id'=>$id,'user_id'=>$userid])->exists();
        if($petionexit)
        {
            $petition = Petition::find($id);
            $petition->decrement('vote_yes');
            $del = PetitionVote::where(['petition_id'=>$id,'user_id'=>$userid])->delete();
            if($del){
                return response()->json([
                    'status_code' => '200',
                    'message' => 'Support has been withdraw',
                ]);
            }
            else{
                return response()->json([
                    'message' => "Try again",
                    'status_code' => '400',
                    'error' => 1
                ]);
            }
        }else{
            return response()->json([
                'message' => "You have not supported this petition already",
                'status_code' => '400',
                'error' => 1
            ]);
        }
    }
    public function survey(Request $request)
    {
        $check = Survey::where('status','Active')->exists();
        if($check){
           $survey = [];
            $list = Survey::where('status','Active')->orderBy('id','desc')->get();
            foreach($list as $li){
                $s_v = SurveyVote::where('survey_id',$li->id)->where('device_id',$request->device_id)->first();
                if(!$s_v){
                    $survey[] = $li;
                }
            }
            return response()->json(
                ['status_code'=>'200',
                'survey'=>  $survey,
                ]);
        }else{
            return response()->json(
                ['status_code'=>'200',
                'message'=>  'No survey found',
                 'survey'=>  [],
                ]);
        }
    }
    public function surveyvote(Request $request)
    {
        $surveyexit = SurveyVote::where(['survey_id'=>$request->survey_id,'device_id'=>$request->device_id])->first();
        if(!$surveyexit){
            $data =new SurveyVote();
            $data->vote = $request->vote;
            $data->survey_id = $request->survey_id;
            $data->user_id = '';
            $data->device_id = $request->device_id;
            $data->save();
            if($data){
                $survey = Survey::find($request->survey_id);
                if($request->vote == 1){
                    $survey->increment('vote_yes');
                }else{
                    $survey->increment('vote_no');
                }
                $survey->save();
                return response()->json([
                    'status_code' => '200',
                    'message' => 'Vote submited successfully',
                ]);
            }else{
                return response()->json([
                        'message' => "Try again",
                        'status_code' => '400',
                        'error' => 1
                    ]);
            }
        }else{
            return response()->json([
                'message' => "You submited vote already",
                'status_code' => '400',
                'error' => 1
            ]);
        }
    }
    public function announcement()
    {
        $check = Announcement::where('status','Active')->exists();
        if($check){
            $list = Announcement::where('status','Active')->orderBy('id','desc')->get();
            return response()->json(
                ['status_code'=>'200',
                'Announcement'=>  $list,
                ]);
        }else{
            return response()->json(
                ['status_code'=>'200',
                'message'=>  'No announcement found',
                'Announcement'=>  [],
                ]);
        }
    }
    public function gallery()
    {
        $check = Gallery::where('status','Active')->exists();
        if($check){
        $list = Gallery::where('status','Active')->orderBy('id','desc')->get();
        // foreach($list as $key=>$val)
        //     {
        //        $photos=  json_decode($val->images);
        //        $list[$key]['images']= $photos;
        //     }
            return response()->json(
                ['status_code'=>'200',
                'Gallery'=>  $list,
                ]);
        }else{
            return response()->json(
                ['status_code'=>'200',
                'message'=>  'No gallery found',
                'Gallery'=>  [],
                ]);
        }
    }
    public function sharenewsfeed(Request $request)
    {
        $exit = NewFeed::where(['id'=>$request->newsfeed_id])->exists();
        if($exit){
            $newsfeed = NewFeed::where(['id'=>$request->newsfeed_id])->first();
            if($newsfeed->shared == 0)
            {
                $nsfeed = new NewFeed();
                $nsfeed->title = $newsfeed->title;
                $nsfeed->description = $newsfeed->description;
                $nsfeed->user_id = $newsfeed->user_id;
                $nsfeed->type = 1;
                $nsfeed->status = 'Active';
                $nsfeed->shareby = Auth()->user()->id;
                $nsfeed->image = $newsfeed->image;
                $nsfeed->video = $newsfeed->video;
                if($nsfeed->save())
                {
                    $newsfeed->shared = 1;
                    $newsfeed->save();
                    return response()->json([
                        'status_code' => '200',
                        'message' => 'Newfeed shared successfully',
                    ]);
                }
                else
                {
                    return response()->json([
                        'message' => "Try again",
                        'status_code' => '400',
                        'error' => 1
                    ]);
                }
            }
            else
            {
                return response()->json([
                    'message' => "SS Newsfeed already shared in newsfeed section.",
                    'status_code' => '400',
                    'error' => 1
                ]);
            }
        }else{
            return response()->json([
                'message' => "Newsfeed does not exist in our record",
                'status_code' => '400',
                'error' => 1
            ]);
        }
    }
    public function savenewsfeed(Request $request)
    {
        $validation = Validator::make($request->all(),[
            'title' => 'required',
            'description' => 'required',
        ]);
        if($validation->fails())
        {
            $error = $validation->errors()->first();
            return response()->json([
                'errors' => $validation->errors(),
                 'message' => $error,
                  'status_code' => '400'
                  ]);
        }
        $newsfeed = new NewFeed();
        $newsfeed->title = $request->title;
        $newsfeed->description = $request->description;
        $newsfeed->user_id = '';//Auth()->user()->id;
        $newsfeed->device_id = $request->device_id;
        $newsfeed->type = 1;
        $newsfeed->status = 'Active';
        if(!empty($request->image))
        {
            $images = $request->image;
            $name = mt_rand(100000, 999999) . time() . '.' . $images->getClientOriginalExtension();
            $destinationPath = public_path('assets/uploads');
            $images->move($destinationPath, $name);
            $newsfeed->image = $name;
        }
        if(!empty($request->video))
        {
            $video = $request->video;
            $name = mt_rand(100000, 999999) . time() . '.' . $video->getClientOriginalExtension();
            $destinationPath = public_path('assets/uploads');
            $video->move($destinationPath, $name);
            $newsfeed->video = $name;
        }
        if($newsfeed->save())
        {
            return response()->json([
                'status_code' => '200',
                'message' => 'Newsfeed has been saved successfully',
            ]);
         }
        else{
            return response()->json([
                'message' => "Try Again",
                'status_code' => '400',
                'error' => 1
               ]);
        }
    }
    // public function allnewsfeed()
    // {
    //     $check = NewFeed::where(['type'=>1,"status"=>'Active'])->exists();
    //     if($check){
    //      //   $newsfeed = NewFeed::where(['type'=>1,"status"=>'Active'])->get();
    //         $newsfeed = NewFeed::join('users', 'new_feeds.user_id', '=', 'users.id')
    //                        ->leftjoin("newsfeed_likes",function($join){
    //                         $join->on("newsfeed_likes.newsfeed_id","=","new_feeds.id");
    //                         $join->where("newsfeed_likes.user_id","=", Auth()->user()->id);
    //                     })
    //                     ->where(['new_feeds.type'=>1,"new_feeds.status"=>'Active'])
    //                     ->orderBy('new_feeds.id','desc')->get(['new_feeds.*', 'users.name as User Name',
    //                     'users.photo as profilephoto','newsfeed_likes.like as newsfeedlike']);
    //         $count = 0;
    //         foreach($newsfeed as $key=>$val)
    //         {
    //             if($val->shareby!=0)
    //             {
    //                 $user = User::where('id',$val->shareby)->first();
    //                 $newsfeed[$count]['shareby'] = $user->name;
    //             }
    //             $count++;
    //         }
    //         // $sharefeed = NewsfeedShare::groupby('newsfeed_id')->get();
    //         // $share = [];
    //         // foreach($sharefeed as $feed){
    //         //     $share[] = NewFeed:: where('id',$feed->newsfeed_id)->first();
    //         // }
    //         // 'sharenewsfeed' => $share,
    //         return response()->json([
    //             'status_code' => '200',
    //             'newsfeed' => $newsfeed,
    //             'message' => 'Newsfeed has been display successfully',
    //         ]);
    //     }else{
    //         return response()->json([
    //             'message' => "No Record Found",
    //             'status_code' => '200',
    //             'newsfeed' => [],
    //             'error' => 1
    //            ]);
    //     }
    // }
    public function allnewsfeed()
    {
        $check = NewFeed::where(['type'=>1,"status"=>'Active'])->exists();
        if($check){
            $newsfeed = NewFeed::where(["status"=>'Active'])->get();
               return response()->json([
                'status_code' => '200',
                'newsfeed' => $newsfeed,
                'message' => 'Newsfeed has been display successfully',
            ]);
        }else{
            return response()->json([
                'message' => "No Record Found",
                'status_code' => '200',
                'newsfeed' => [],
                'error' => 1
               ]);
        }
    }   
    public function newsfeedbyid($id)
    {
        $check = NewFeed::where(['type'=>1,"id"=>$id])->exists();
        if($check){
            $newsfeed = NewFeed::where(['type'=>1,"id"=>$id])->get();
            return response()->json([
                'status_code' => '200',
                'newsfeed' => $newsfeed,
                'message' => 'Newsfeed has been display successfully',
            ]);
        }else{
            return response()->json([
                'message' => "No Record Found",
                'status_code' => '400',
                'error' => 1
               ]);
        }
    }
    public function mynewsfeed($device_id)
    {
        $check = NewFeed::where(['type'=>1,"device_id"=>$device_id])->exists();
        if($check){
            $newsfeed = NewFeed::where(['type'=>1,"device_id"=>$device_id])->get();
            return response()->json([
                'status_code' => '200',
                'newsfeed' => $newsfeed,
                'message' => 'Newsfeed has been display successfully',
            ]);
        }else{
            return response()->json([
                'message' => "No Record Found",
                'status_code' => '400',
                'error' => 1
               ]);
        }
    }
    public function mpnewsfeed(Request $reqeust)
    {
        $check = NewFeed::where(['type'=>2,'status'=>'Active'])->exists();
        if($check){
            $newsfeed = NewFeed::where(['type'=>2,'status'=>'Active'])->get();
        //   $newsfeed = NewFeed::join('users', 'new_feeds.user_id', '=', 'users.id')
        //   ->leftjoin("newsfeed_likes",function($join){
        //      $join->on("newsfeed_likes.newsfeed_id","=","new_feeds.id");
        //      $join->where("newsfeed_likes.user_id","=", Auth()->user()->id);
        //  })
        //   ->where(['new_feeds.type'=>2,"new_feeds.status"=>'Active'])
        //   ->orderBy('new_feeds.id','desc')->get(['new_feeds.*', 'users.name as User Name','users.photo as profilephoto',
        //   'newsfeed_likes.like as newsfeedlike']);
            return response()->json([
                'status_code' => '200',
                'newsfeed' => $newsfeed,
                'message' => 'SS Newsfeed has been display successfully',
            ]);
        }else{
            return response()->json([
                'message' => "No Record Found",
                'status_code' => '200',
                'newsfeed' => [],
                'error' => 1
               ]);
        }
    }
    public function mpnewsfeedbyid($id)
    {
        $check = NewFeed::where(['type'=>2,"id"=>$id])->exists();
        if($check){
            $newsfeed = NewFeed::where(['type'=>2,"id"=>$id])->get();
            return response()->json([
                'status_code' => '200',
                'newsfeed' => $newsfeed,
                'message' => 'MP Newsfeed has been display successfully',
            ]);
        }else{
            return response()->json([
                'message' => "No Record Found",
                'status_code' => '400',
                'error' => '1'
               ]);
        }
    }
    public function addnewsfeedlike(Request $request)
    {
        $validation = Validator::make($request->all(),[
            'newsfeed_id' => 'required',
            'device_id'  => 'required',
            ]);
        if($validation->fails())
        {
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
            'message' => $error,
                'status_code' => '400'
                ]);
        }
        $id = $request->newsfeed_id;
        //$uid = Auth()->user()->id;
        $check = NewsfeedLike::where(['newsfeed_id'=>$id,"device_id"=>$request->device_id])->exists();
        if($check){
            $newsfeed = Newfeed::find($id);
            $newsfeed->decrement('likes');
            $del = NewsfeedLike::where(['newsfeed_id'=>$id,"device_id"=>$request->device_id])->delete();
            return response()->json([
                'message' => "You have already like this newsfeed So now it is Unlike",
                'status_code' => '200',
            ]);
        }
        else{
            $newsfeed = Newfeed::find($id);
            if($newsfeed->device_id  != $request->device_id){
                $newsfeed->increment('likes');
                if($newsfeed->save()){
                    $newsfeedlike = new NewsfeedLike();
                    $newsfeedlike->newsfeed_id = $request->newsfeed_id;
           			$newsfeedlike->user_id = '';//Auth()->user()->id;
           			$newsfeedlike->like = 1;
                    $newsfeedlike->device_id = $request->device_id;
                    $newsfeedlike->save();
                    if($newsfeedlike){
                        // $user  = User::where('id',$newsfeed->user_id)->first();
                        // $token = $user->firebase_token;
                        // $device = $user->os;
                        // $title = 'Liked';
                        // $body  =  Auth()->user()->name.' Like your newfeed';
                        // $click_action = 'NewFeed';
                        // $this->NotificationSend($token,$user->id,$title,$body,$click_action,$device);
                    }
                    return response()->json([
                        'status_code' => '200',
                        'message' => 'Like has been added successfully',
                    ]);
                }else{
                    return response()->json([
                        'message' => "Try Again",
                        'status_code' => '400',
                        'error' => 1
                    ]);
                }
            }else{
                return response()->json([
                        'message' => "You cant like your own newfeed",
                        'status_code' => '400',
                        'error' => 1
                ]);
            }
        }
    }
   public function allcondolences()
   {
    $check = Memoir::where(['status'=>'Active'])->exists();
    if($check){
        $condolences = Memoir::where(['status'=>'Active'])->orderBy('id','desc')->get();
        return response()->json([
            'status_code' => '200',
            'condolences' => $condolences,
            'message' => 'Condolences has been display successfully',
        ]);
    }else{
        return response()->json([
            'message' => "No Record Found",
            'status_code' => '400',
             'condolences' => [],
            'error' => '1'
           ]);
    }
   }
   public function getcondolencesbyid($id)
   {
    $check = Memoir::where(['id'=>$id])->exists();
    if($check){
        $condolences = Memoir::where(['id'=>$id])->get();
        return response()->json([
            'status_code' => '200',
            'condolence' => $condolences,
            'message' => 'Condolence has been display successfully',
        ]);
    }else{
        return response()->json([
            'message' => "No Record Found",
            'status_code' => '200',
            'error' => '1'
           ]);
    }
   }
   public function aboutme()
   {
    $check = AboutMe::where(['id'=>1])->exists();
    if($check){
        $aboutme = AboutMe::where(['id'=>1])->get();
        return response()->json([
            'status_code' => '200',
            'aboutme' => $aboutme,
            'message' => 'Aboutme has been display successfully',
        ]);
    }else{
        return response()->json([
            'message' => "No Record Found",
            'status_code' => '400',
            'error' => '1'
           ]);
    }
   }
   public function uploadgallery(Request $request)
   {
        $validation = Validator::make($request->all(),[
            'title' => 'required',
            'location'   => 'required',
            'image'  => 'required',
        ]);
        if($validation->fails())
        {
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
            'message' => $error,
                'status_code' => '400'
                ]);
        }
        $photo = array();
        $gallerysave = false;
        if($request->hasfile('image')) {
            foreach($request->file('image') as $file)
            {
                $gallery = new Gallery();
                $name = mt_rand(100000, 999999) . time() . '.' . $file->getClientOriginalExtension();
                $destinationPath = public_path('assets/uploads');
                $file->move($destinationPath, $name);
                $photo[] = $name;
                $gallery->title = $request->title;
                $gallery->address = $request->location;
                $gallery->user_id = '';//Auth()->user()->id;
                $gallery->images = $name;
                $gallery->device_id = $request->device_id;
                $gallery->save();
                $gallerysave = true;
           }
        }
        if($gallerysave) {
        return response()->json([
            'message' => "Images has been uplaoded successfully",
            'status_code' => '200',
            ]);
       }
       else {
        return response()->json([
            'message' => "Try Again",
            'status_code' => '400',
            'error' => 1
        ]);
       }
   }
   public function contactme(Request $request)
   {
       $email =  'info@sophianaqvi.listen2me.biz';
        $validation = Validator::make($request->all(),[
            'name' => 'required',
            'email' => 'required',
            'detail'   => 'required',
        ]);
        if($validation->fails())
        {
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
            'message' => $error,
                'status_code' => '400'
                ]);
        }
        $data = array(
            'name'  => $request->name,
            'email' => $request->email,
            'detail' => $request->detail,
        );
        Mail::send('contactme', $data, function($message) use ($email){
            $message->to($email,  'SophiaNaqvi')->subject
            ('Contact Me');
            $message->from($email,  'SophiaNaqvi');
        });
        $check_contact = ContactUs::where('email',$request->email)->exists();
        if($check_contact)
        {
            return response()->json([
                'message' => 'Your contact already exist',
                'status_code' => 200,
            ],200);
        }
        else
        {
            $contactobj = new ContactUs();
            $contactobj->name = $request->name;
            $contactobj->email = $request->email;
            $contactobj->message = $request->detail;
            $contactobj->device_id = $request->device_id;
            $contactobj->save();
            return response()->json([
                'message' => "Your information has been sent successfully.Admin will contact you.",
                'status_code' => '200',
                ],200);
        }
   }
//    public function sendnotification(Request $request)
//    {
//        $token = 'cYNzE19iIkkdg89X8aqdcI:APA91bHAQriJ6MU5ov9nTxIkb_wABbTgiZd2EsOulC_c0YxNx2DpSxt-sN_EmSCjK5oOdZK2gbqCOFlcSjtl4ZCvsYB4a9WdWOMjr8HfTvQC-tIrsSTlgG4-9Zrgm-C4SgyTYvW2Wn_p';
//        $message = 'Hello ...Usama if you recive this message tell to Kashif';
//        $firebase = new Firebase();
//        $data =  $firebase->send($token,json_decode($message));
//        print_r($data);
//    }
   public function notificationList()
   {
        $lists = Notification::where('user_id', auth()->user()->id)->orderBy('id','desc')->paginate(10);
        if(count($lists) > 0){
            return response()->json([
                'lists' => $lists,
                'message' => 'List Found',
                'status_code' => '200'
            ]);
        }else{
            return response()->json([
                'message' => "List Not Fount",
                'status_code' => '400',
                'lists' => $lists,
                'error' => 1
            ]);
        }
    }
   public function notificationRead(Request $request){
    $read = Notification::where('user_id', auth()->user()->id)->where('id',$request->notify_id)->update(['read_at' => 1]);
    if($read){
        return response()->json([
            'message' => 'Mark as read successfully',
            'status_code' => '200'
        ]);
    }else{
        return response()->json([
            'message' => "Try Again",
            'status_code' => '400',
            'error' => 1
        ]);
    }
}
public function mycomplaintstatus()
{
        $totalpending = Complaint::where(['status_id'=>3,'user_id'=>Auth()->user()->id])->get()->count();
        $totalresolved = Complaint::where(['status_id'=>5,'user_id'=>Auth()->user()->id])->get()->count();
        $totalinreview = Complaint::where(['status_id'=>4,'user_id'=>Auth()->user()->id])->get()->count();
        $totalsubmitted = Complaint::where(['status_id'=>1,'user_id'=>Auth()->user()->id])->get()->count();
           return response()->json(
            ['status_code'=>'200',
            'totalpending'=>  $totalpending,
            'totalresolved'=>  $totalresolved,
            'totalinreview'=>  $totalinreview,
            'totalsubmitted'=>  $totalsubmitted,
             ]);
}
public function jointhefight(Request $request)
{
    $validation = Validator::make($request->all(), [
        'reason' => 'required',
    ]);
    if ($validation->fails()) {
        return response()->json(['errors' => $validation->errors()->first(), 'error' => true, 'status_code' => 400],401);
    }
    $fight = new JoinTheFight();
    $fight->reason = $request->reason;
    $fight->device_id = $request->device_id;
    if($fight->save())
    {
        $data['status_code'] = 200;
        $data['message'] = "Thank you for submitting the form.";
        return response()->json($data,200);
    }
    else
    {
        $data['status_code'] = 400;
        $data['message'] = "Something went wrong.Try again later.";
        return response()->json($data,400);
    }
}
//================================Admin Panel ===================================//
public function addsurvey(Request $request)
{
    $validation = Validator::make($request->all(),[
        'title' => 'required',
        'description' => 'required',
    ]);
    if($validation->fails()){
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
            'message' => $error,
            'status_code' => 400,
        ],400);
    }
    $survey = new Survey();
    $survey->title = $request->title;
    $survey->description = $request->description;
    $survey->user_id = Auth()->user()->id;
    $survey->status = 'Active';
    if($survey->save())
    {
        $token = '/topics/news';
        $title = $request->title;
        $body =  $request->description;
        $click_action = 'Survey';
        $token1 = '/topics/newsAndroid';
        $this->NotificationTopicSend($token1,$title,$body,$click_action,'android');
        $this->NotificationTopicSend($token,$title,$body,$click_action,'ios');
        return response()->json([
            'message' => "Survey has been added successfully.",
            'status_code' => 200,
        ],200);
    }
    else{
        return response()->json([
            'message' => 'Something went wrong! Try again later.',
            'status_code' => 403,
        ],403);
    }
}
public function modifysurvey(Request $request,$id)
{
    $validation = Validator::make($request->all(),[
        'title' => 'required',
        'description' => 'required',
    ]);
    if($validation->fails())
    {
        $error = $validation->errors()->first();
        return response()->json([
            'errors'=> $validation->errors(),
            'message' => $error,
             'status_code' => 400,
        ],400);
    }
    $survey = Survey::find($id);
    if($survey)
    {
        $survey->title = $request->title;
        $survey->description = $request->description;
        $survey->save();
        return response()->json([
            'message' => 'Survey has been modified successfully',
            'status_code' => 200,
        ],200);
    }
    else
    {
        return response()->json([
            'message' => 'Survey not found',
            'status_code' => 403,
        ],403);
    }
}
public function deletesurvey($id)
{
    $survey = Survey::find($id);
    if($survey)
    {
        $survey->delete();
        return response()->json([
            'message' => 'Survey has been deleted successfully',
            'status_code' => 200,
        ],200);
    }
    else
    {
        return response()->json([
            'message'=> 'Survey not found.',
            'status_code' => 403,
        ],403);
    }
}
public function addannouncement(Request $request)
{
    $validation = Validator::make($request->all(),[
        'title' => 'required',
        'description' => 'required',
    ]);
    if($validation->fails()){
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
            'message' => $error,
            'status_code' => 400,
        ],400);
    }
    $announcement = new Announcement();
    $announcement->title = $request->title;
    $announcement->description = $request->description;
    $announcement->status = 'Active';
    if($announcement->save())
    {
        $token = '/topics/news';
        $title = $request->title;
        $body =  $request->description;
        $click_action = 'Announcement';
        $token1 = '/topics/newsAndroid';
        $this->NotificationTopicSend($token1,$title,$body,$click_action,'');
        $this->NotificationTopicSend($token,$title,$body,$click_action,'');
        return response()->json([
            'message' => "Announcement has been added successfully.",
            'status_code' => 200,
        ],200);
    }
    else{
        return response()->json([
            'message' => 'Something went wrong! Try again later.',
            'status_code' => 403,
        ],403);
    }
}
public function modifyannouncement(Request $request,$id)
{
    $validation = Validator::make($request->all(),[
        'title' => 'required',
        'description' => 'required',
    ]);
    if($validation->fails())
    {
        $error = $validation->errors()->first();
        return response()->json([
            'errors'=> $validation->errors(),
            'message' => $error,
             'status_code' => 400,
        ],400);
    }
    $announcement = Announcement::find($id);
    if($announcement)
    {
        $announcement->title = $request->title;
        $announcement->description = $request->description;
        $announcement->save();
        return response()->json([
            'message' => 'Announcement has been modified successfully',
            'status_code' => 200,
        ],200);
    }
    else
    {
        return response()->json([
            'message' => 'Announcement not found',
            'status_code' => 200,
        ],200);
    }
}
public function deleteannouncement($id)
{
    $announcement = Announcement::find($id);
    if($announcement)
    {
        $announcement->delete();
        return response()->json([
            'message' => 'Announcement has been deleted successfully',
            'status_code' => 200,
        ],200);
    }
    else
    {
        return response()->json([
            'message'=> 'Announcement not found.',
            'status_code' => 403,
        ],403);
    }
}
public function addnewsfeed(Request $request)
{
    $validation = Validator::make($request->all(),[
        'title' => 'required',
        'description' => 'required',
        'image' => 'mimes:jpeg,jpg,gif|max:2048',
        // 'video' => 'mimes:mp4,mov,ogg | max:20000',
    ]);
    if($validation->fails()){
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
            'message' => $error,
            'status_code' => 400,
        ],400);
    }
    $newFeed = new NewFeed();
    $newFeed->title = $request->title;
    $newFeed->description = $request->description;
    $newFeed->user_id = Auth()->user()->id;
    $newFeed->type = 2;
    $newFeed->status = 'Active';
    $newFeed->profilephoto = 'sophia_naqvi.png';
    if($request->image){
        $fileName = time().'.'.$request->image->extension();
        $request->image->move(public_path('assets/uploads'), $fileName);
        $newFeed->image = $fileName;
    }
    // if($request->video){
    //     $fileName1 = time().'.'.$request->video->extension();
    //     $request->video->move(public_path('assets/uploads'), $fileName1);
    //     $newFeed->video = $fileName1;
    // }
    if($newFeed->save())
    {
        $token1 = '/topics/newsAndroid';
            $token = '/topics/news';
            $title = 'NewFeed';
            $body =  'SN has posted something new- You can share it now ';
            $click_action = 'NewFeed';
            $this->NotificationTopicSend($token1,$title,$body,$click_action,'android');
            $this->NotificationTopicSend($token,$title,$body,$click_action,'ios');
        return response()->json([
            'message' => "Newsfeed has been added successfully.",
            'status_code' => 200,
        ],200);
    }
    else{
        return response()->json([
            'message' => 'Something went wrong! Try again later.',
            'status_code' => 403,
        ],403);
    }
}
public function modifynewsfeed(Request $request,$id)
{
    $validation = Validator::make($request->all(),[
        'title' => 'required',
        'description' => 'required',
    ]);
    if($validation->fails()){
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
            'message' => $error,
            'status_code' => 400,
        ],400);
    }
    $newFeed = NewFeed::find($id);
    $newFeed->title = $request->title;
    $newFeed->description = $request->description;
    if($request->image){
        $fileName = time().'.'.$request->image->extension();
        $request->image->move(public_path('assets/uploads'), $fileName);
        $newFeed->image = $fileName;
    }
    // if($request->video){
    //     $fileName1 = time().'.'.$request->video->extension();
    //     $request->video->move(public_path('assets/uploads'), $fileName1);
    //     $newFeed->video = $fileName1;
    // }
    if($newFeed->save())
    {
        return response()->json([
            'message' => "Newsfeed has been modified successfully.",
            'status_code' => 200,
        ],200);
    }
    else{
        return response()->json([
            'message' => 'Something went wrong! Try again later.',
            'status_code' => 403,
        ],403);
    }
}
public function deletenewsfeed($id)
{
    $newFeed = NewFeed::find($id);
    if($newFeed)
    {
        $newFeed->delete();
        return response()->json([
            'message' => 'Newsfeed has been deleted successfully',
            'status_code' => 200,
        ],200);
    }
    else
    {
        return response()->json([
            'message'=> 'Newsfeed not found.',
            'status_code' => 403,
        ],403);
    }
}
public function disablenewsfeed(Request $request,$id)
{
    $newFeed = NewFeed::find($id);
    if($newFeed)
    {
        if($newFeed->status == 'Active')
        {
            $newFeed->status = 'Disable';
            $message = 'Newsfeed has been disabled successfully.';
        }
        else
        {
            $newFeed->status = 'Active';
            $message = 'Newsfeed has been activate successfully.';
        }
        if($newFeed->save())
        {
            return response()->json([
                'message' => $message,
                'status_code' => 200,
            ],200);
        }
        else{
            return response()->json([
                'message' => 'Something went wrong! Try again later.',
                'status_code' => 403,
            ],403);
        }
    }
    else
    {
        return response()->json([
            'message' => 'Newsfeed not found',
            'status_code' => 403,
        ],403);
    }
}
public function newsfeedlist()
{
    $newsfeed = NewFeed::exists();
    if($newsfeed)
    {
        $newsfeedlist = NewFeed::all();
        return response()->json([
            'message' => 'Newsfeed list display successfully.',
            'status_code' => 200,
            'newsfeed' => $newsfeedlist,
        ],200);
    }
    else
    {
        return response()->json([
            'message' => 'No newsfeed found.',
            'status_code' => 200,
        ],200);
    }
}
public function supportmanagement()
{
    $donation = Donation::all();
    return response()->json([
        'message' => 'Support list has been displayed successfully',
        'support' => $donation,
    ]);
}
public function addgallery(Request $request)
{
    $validation = Validator::make($request->all(),[
        'images' => 'required|mimes:jpeg,png,jpg,gif|max:2048',
    ]);
    if($validation->fails()){
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
            'message' => $error,
            'status_code' => 400,
        ],400);
    }
    $gallery = new Gallery();
    $fileName = time().'.'.$request->images->extension();
    $request->images->move(public_path('assets/uploads'), $fileName);
    $gallery->user_id = Auth()->user()->id;
    $gallery->images = $fileName;
    $gallery->title = $request->title;
    $gallery->address = $request->address;
    $gallery->status = 'Active';
    if($gallery->save())
    {
        $token = '/topics/news';
        $title = $request->title;
        $body =  $request->address;
        $click_action = 'Gallery';
        $token1 = '/topics/newsAndroid';
        $this->NotificationTopicSend($token1,$title,$body,$click_action,'android');
        $this->NotificationTopicSend($token,$title,$body,$click_action,'ios');
        return response()->json([
            'message' => 'Gallery has been added successfully',
            'status_code' => 200,
        ],200);
    }
}
public function deletegallery($id)
{
    Gallery::find($id)->delete();
    return response()->json([
        'message' => 'Gallery has been deleted successfully',
        'status_code' => 200,
    ],200);
}

public function modifyaboutme(Request $request,$id)
{
    $validation = Validator::make($request->all(),[
        'about_me' => 'required',
    ]);
    if($validation->fails()){
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
            'message' => $error,
            'status_code' => 400,
        ],400);
    }
    $aboutme = AboutMe::find($id);
    $aboutme->about_me = $request->about_me;
    if($aboutme->save())
    {
        return response()->json([
            'message' => 'About us has been modified successfully',
            'status_code' => 200,
        ],200);
    }
}
public function surveylist()
{
    $survery = Survey::exists();
    if($survery)
    {
        $survery = Survey::all();
        return response()->json([
            'message' => 'Survey list display successfully.',
            'survey' => $survery,
            'status_code' => 200,
        ],200);
    }
    else
    {   
        return response()->json([
            'message' => 'No Survey found',
            'status_code' => 200,
        ],200);
    }
}
public function jointhefightlist()
{
    $exists = JoinTheFight::exists();
    if($exists)
    {
        $list = jointhefight::all();
        return response()->json([
            'message' => 'Record display successfully',
            'status_code' => 200,
            'list' => $list,
        ]);
    }
    else
    {
        return response()->json([
            'message' => 'No Record Found',
            'status_code' => 200,
        ],200);
    }
}
public function contactuslist()
{
    $check = ContactUs::exists();
    if($check)
    {
        $list = ContactUs::orderBy('id','DESC')->get();
        return response()->json([
            'message' =>'Contact Us list display successfully.',
            'status_code' => 200,
            'list' => $list,
        ],200);
    }
    else
    {
        return response()->json([
            'message' => 'No Record Found',
            'status_code' => 200,
        ],200);
    }
}
public function userStatus(Request $request)
{
    $validation = Validator::make($request->all(),[
        'device_id' => 'required',
    ]);
    if($validation->fails()){
        $error = $validation->errors()->first();
        return response()->json([
            'errors' => $validation->errors(),
            'message' => $error,
            'status_code' => 400,
        ],400);
    }
    $check = ContactUs::where('device_id',$request->device_id)->exists();
    if($check)
    {
        $utype =  ContactUs::where('device_id',$request->device_id)->select('usertype')->first();
        return response()->json([
            'type' => $utype,
        ],200);
    }
    else
    {
        return response()->json([
            'message' => 'No record found',
            'status_code' => 403,
        ],403);
    }
}
public function makeadminuser(Request $request)
{
    $contact_id = $request->contact_id;
    $conact_info = ContactUs::find($contact_id);
    if($conact_info->usertype == 'User')
    {
        $conact_info->usertype = 'Admin';
        $conact_info->save();
        $user = User::withTrashed()->where('email', $conact_info->email)->first();
        if($user)
        {
            $user->deleted_at = NULL;
            $user->save();
            return response()->json([
                'message' => 'User role has been change into admin',
                'status_code' => 200,
            ],200);
        }
        else
        {
            $user = User::create([
                'name' => $conact_info->name,
                'email' => $conact_info->email,
                'password' => Hash::make('12345678'),
                'role' => 'Admin',
                'device_id' => $conact_info->device_id,
                'status' => 3,
            ]);
            return response()->json([
                'message' => 'User role has been change into admin',
                'status_code' => 200,
            ],200);
        }
    }
    else
    {
        $del = User::where('email',$conact_info->email)->delete();
        $conact_info->usertype = 'User';
        $conact_info->save();
        return response()->json([
            'message' => 'Role has been changed into user',
            'status_code' => 200,
        ],200);
    }
}

// ===================Podcast Api ==============================//
public function agoraToken(Request $request){
    $appID = "6db8590331fb4aa6b8bef49de184e6b6";
    $appCertificate = "bb6c0a6f61234cabb33f4464e355863e";
    $channelName = $request->channelName;
    $uid = Str::random(10);
    $uidStr = "2882341273";
    $role = RtcTokenBuilder::RoleAdmin;
    $expireTimeInSeconds = 1800;
    $currentTimestamp = (new DateTime("now", new DateTimeZone('UTC')))->getTimestamp();
    $privilegeExpiredTs = $currentTimestamp + $expireTimeInSeconds;
    $token = RtcTokenBuilder::buildTokenWithUid($appID, $appCertificate, $channelName, $uid, $role, $privilegeExpiredTs);
    $role1 = RtmTokenBuilder::RoleRtmUser;
    $token1 = RtmTokenBuilder::buildToken($appID, $appCertificate, $uid, $role1, $privilegeExpiredTs);
    $data['status_code'] = 200;
    $data['RtcToken'] = $token;
    $data['RtmToken'] = $token1;
    return response()->json($data);
}
public function createPodcast(Request $request)
{


    $validation = Validator::make($request->all(), [
        'title' => 'required',
        'date' => 'required',
                      
    ]);

    if ($validation->fails()) {
        return response()->json(['errors' => $validation->errors()->first(), 'error' => true, 'status_code' => 400],401);
    }

    $podcast = new Podcast;
    $podcast->title  = $request->title;
    $podcast->date  = $request->date;
    $podcast->joincounter = 0;
    $podcast->podcastdate = date('Y-m-d',strtotime($request->date));
    $podcast->status = 'Live';
    if($request->is_recorded)
    {
        $podcast->is_recorded = $request->is_recorded;
    }

    
   
    if($request->image){
        $images = $request->image;
        $name = mt_rand(100000, 999999).time().'.'.$images->getClientOriginalExtension();
        $destinationPath = public_path('/uploads/podcast');
        $images->move($destinationPath, $name);
        $podcast->image = $name;
    }

        


    if($podcast->save()){
       
        $expirytokentime = 3600;
        $appID = "2eca8faa67844096aa2379db859ed7f6";
        $appCertificate = "48c64f00faf8444d9b422cd3b885b205";
        $channelName = 'Sophia_Channel_'.$podcast->id;
        $uid = '';// Str::random(10);
        $uidStr = "2882341273";
        $role = RtcTokenBuilder::RoleAdmin;
        $expireTimeInSeconds = 0;
        if (isset($request->tokentime))
        {
            $expireTimeInSeconds = $request->tokentime*60;
        }
        else
        {
           $expireTimeInSeconds = $expirytokentime ;//3600;//10800;
        }
        $currentTimestamp = (new DateTime("now", new DateTimeZone('UTC')))->getTimestamp();
        $privilegeExpiredTs = $currentTimestamp + $expireTimeInSeconds;
        $token = RtcTokenBuilder::buildTokenWithUid($appID, $appCertificate, $channelName, $uid, $role, $privilegeExpiredTs);
        // $podcast->token = $token;
        // $podcast->channel_id = $channelName;
        Podcast::where('id',$podcast->id)->update(['channel_id'=>$channelName,'token'=>$token]);

        if($podcast->is_recorded == 1)
        {

       
           $curl = curl_init();
           curl_setopt_array($curl, array(
           CURLOPT_URL => "https://api.agora.io/v1/apps/".env('APPID')."/cloud_recording/acquire",
           CURLOPT_RETURNTRANSFER => true,
           CURLOPT_ENCODING => '',
           CURLOPT_MAXREDIRS => 10,
           CURLOPT_TIMEOUT => 0,
           CURLOPT_FOLLOWLOCATION => true,
           CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
           CURLOPT_CUSTOMREQUEST => 'POST',
           CURLOPT_POSTFIELDS =>'{
               "cname": "'.$channelName.'",
               "uid": "'.$podcast->id.'",
               "clientRequest": {
                   "resourceExpiredHour": 24,
                   "scene": 0
               }
           }',
           CURLOPT_HTTPHEADER => array(
               'Content-Type: application/json',
               'Authorization: Basic ' . base64_encode(''.env("CustomerID").':'.env("CustmerSecret").''),
           ),
           ));

           $response = curl_exec($curl);
           curl_close($curl);   
           //echo $respone->resourceId;

           //============================End ====================================//
           $decode = json_decode($response);
           $data['resouceId'] = $decode->resourceId;
           $resourceid = '';
           if($decode->resourceId)
           {
               $curl = curl_init();
               $resourceid  = $decode->resourceId;
               curl_setopt_array($curl, array(
               CURLOPT_URL => "https://api.agora.io/v1/apps/".env('APPID')."/cloud_recording/resourceid/".$resourceid."/mode/".env('Mode')."/start",
               CURLOPT_RETURNTRANSFER => true,
               CURLOPT_ENCODING => '',
               CURLOPT_MAXREDIRS => 10,
               CURLOPT_TIMEOUT => 0,
               CURLOPT_FOLLOWLOCATION => true,
               CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
               CURLOPT_CUSTOMREQUEST => 'POST',
               CURLOPT_POSTFIELDS =>'{
                   "cname":"'.$channelName.'",
                   "uid":"'.$podcast->id.'",
                   "clientRequest":{
                       "token":"'.$token.'",
                       "recordingConfig":
                       {
                           "maxIdleTime":120,
                           "streamTypes":0,
                           "audioProfile":1,
                           "channelType":1,
                           "videoStreamType":0,
                                   "subscribeAudioUids": [
                                       "#allstream#"
                                   ]
                       },
                       "recordingFileConfig": {
                           "avFileType": [
                               "hls",
                               "mp4"
                           ]
                       },
               
                       "storageConfig":{
                           "vendor":1,
                           "region":5,
                           "bucket":"'.env('Bucket').'",
                           "accessKey":"'.env('AccessKey').'",
                           "secretKey":"'.env('SecretKey').'"
                       }
                           
                       
                   }
               } ',
               CURLOPT_HTTPHEADER => array(
                   'Content-Type: application/json',
                   'Authorization: Basic ' . base64_encode(''.env("CustomerID").':'.env("CustmerSecret").''),
               ),
               ));

               $response = curl_exec($curl);
               curl_close($curl);
               $dstartresponse = json_decode($response);
               $data['sid'] = $dstartresponse->sid;
               if($dstartresponse->sid)
               {
                   $sid = $dstartresponse->sid;
                   $curl = curl_init();
                   curl_setopt_array($curl, array(
                   CURLOPT_URL => "https://api.agora.io/v1/apps/".env('APPID')."/cloud_recording/resourceid/".$resourceid."/sid/".$sid."/mode/".env('Mode')."/query",
                   CURLOPT_RETURNTRANSFER => true,
                   CURLOPT_ENCODING => '',
                   CURLOPT_MAXREDIRS => 10,
                   CURLOPT_TIMEOUT => 0,
                   CURLOPT_FOLLOWLOCATION => true,
                   CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                   CURLOPT_CUSTOMREQUEST => 'GET',
                   CURLOPT_HTTPHEADER => array(
                       'Content-Type: application/json',
                       'Authorization: Basic ' . base64_encode(''.env("CustomerID").':'.env("CustmerSecret").''),
                   ),
                   ));

                   $response = curl_exec($curl);
                   curl_close($curl);
                   $queryresponse = json_decode($response);
                   $data['query'] = $queryresponse;
                   Podcast::where('id',$podcast->id)->update(['resourceid'=>$resourceid,'sid'=>$sid]);

               }
           }
        }

        $query = Podcast::query();
        $row = Podcast::where('id',$podcast->id)->first();
        $array1 = [];
        $array1['id'] = $row->id;
        $array1['date']  = $row->date;
        $array1['title']  = $row->title;
        if($row->image!='')
        {
            $array1['image']  = url('/uploads/podcast').'/'.$row->image;
        }
        else
        {
            $array1['image'] = '';
        }

       
        $array1['token'] = $row->token;
        $array1['channel_id'] = $row->channel_id;
       
        $array1['joincounter'] = $row->joincounter;
        $array1['status'] = $row->status;
        $array1['date'] = $row->date;
        
      
        //

        $data['data'] =  $array1;//$podcast->id;
        $data['status_code'] = 200;
        $data['message'] =  'Podcast create successfully';


    }else{
        $data['status_code'] = 400;
        $data['token'] = '';
        $data['channel_id'] = '';
        $data['message'] =  'Try again';
        return response()->json($data,401);
    }

    return response()->json($data);
}

public function joinaudience(Request $request)
{
    $validation = Validator::make($request->all(), [
        'podcast_id' => 'required',
        'device_id' => 'required',
                      
    ]);

    if ($validation->fails()) {
        return response()->json(['errors' => $validation->errors()->first(), 'error' => true, 'status_code' => 400],401);
    }

    $check = PodcastMember::where(['podcast_id'=> $request->podcast_id,'device_id'=>$request->device_id])->exists();
    if($check)
    {
        return response()->json([
            'message' => 'You have already joined this stream',
            'status_code' => 403,
        ],403);
    }
    else
    {
        $podcast = new PodcastMember();
        $podcast->podcast_id = $request->podcast_id;
        $podcast->device_id = $request->device_id;
        $podcast->is_live = 1;
        if($podcast->save())
        {
            $podcast_live = Podcast::where('id',$request->podcast_id)->first();
            $podcast_live->increment('joincounter');
            $podcast_live->save();

            return response()->json([
                'message' => 'You have been successfully joined this stream',
                'status_code' => 200,
            ],200);
        }
        else
        {
            return response()->json([
                'message' => 'Something went wront, Try again later.',
                'status_code' => 403,
            ],403);
        }
        
    }

}

public function leavePodcast(Request $request)
{
    $validation = Validator::make($request->all(), [
             'podcast_id' => 'required'
    ]);

    if ($validation->fails()) {
        return response()->json(['errors' => $validation->errors()->first(), 'error' => true, 'status_code' => 400],401);
    }

    $check = Podcast::where(['id'=>$request->podcast_id])->exists();
    if($check)
    {
        $podcast = Podcast::where(['id'=>$request->podcast_id])->first();
        $podcast->status = 'Stream';
       
        if($podcast->save())
        {
                 $data['status_code'] = 200;
                 $data['message'] =  'Leave successfully';

                 //===================Stop Cloud Recording =========================//
                if($podcast->is_recorded == 1)
                {
                    
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.agora.io/v1/apps/".env('APPID')."/cloud_recording/resourceid/".$podcast->resourceid."/sid/".$podcast->sid."/mode/".env('Mode')."/stop",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS =>'{
                        "cname": "'.$podcast->channel_id.'",
                        "uid": "'.$podcast->id.'",
                        "clientRequest": {}
                    }',
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json;charset=utf-8',
                        'Authorization: Basic ' . base64_encode(''.env("CustomerID").':'.env("CustmerSecret").''),
                    ),
                    ));

                    $response = curl_exec($curl);
                    curl_close($curl);   
                    $leaveresponse = json_decode($response);
                  //  $data['uploadingStatus']  = $leaveresponse;
                    if (property_exists($leaveresponse, 'serverResponse')) {
                        $serverResponse = $leaveresponse->serverResponse;
                        if(property_exists($serverResponse, 'fileList')) 
                        {
                            $fileList = $serverResponse->fileList;
                            $data['response'] =   $leaveresponse->serverResponse->fileList[1]->fileName;  
                            $recorded_file = $leaveresponse->serverResponse->fileList[1]->fileName;
                            Podcast::where(['id'=>$podcast->id])->update(['recorded_file'=>$recorded_file]); 
                            $data['uploadingStatus'] = $leaveresponse->serverResponse->uploadingStatus;
                        }
                        else
                        {
                            $data['uploadingStatus'] = $leaveresponse->code;
                        }
                    }
                    else
                    {
                        $data['response'] =   $leaveresponse;
                    }

                    
                    
                    
                } 
                 //==============================End Cloud Recording ==============//
        }
        else
        {
            $data['status_code'] = 400;
            $data['message'] =  'Try again';
            return response()->json($data,401);
        }
    }
    else
    {
            $data['status_code'] = 400;
            $data['message'] =  'No Record Found';
            return response()->json($data,401);
    }

    //==========================Stop Cloud Recording ================================//
    
    
    return response()->json($data);

}

public function streampodcast()
{
    $exist = Podcast::where('status','Stream')->exists();
    if($exist)
    {
        $podcast = Podcast::where('status','Stream')->get();
        return response()->json([
            'message' => 'Stream Podcast has been displayed successsfully',
            'status' => 200,
            'data' => $podcast,
        ]);
    }
    else
    {
        return response()->json([
            'message' => 'No Stream Podcast found.',
            'status' => 200,
        ],200);
    }
}

public function deletepodcast($id)
{
   
    $check=Podcast::where('id',$id)->exists();
    if($check)
    {
        $del = Podcast::where('id',$id)->delete();
        if($del)
        {
            return response()->json([
                'message' => 'Podcast has been deleted successfully',
                'status_code' => 200,
            ],200);
        }
        else
        {
            return response()->json([
                'message' => 'Something went wrong . Try again later.',
                'status_code' => 403,
            ],403);
        }
    }
    else
    {
        return response()->json([
            'message' => 'No Podcast found.',
            'status_code' => 403,
        ],403);
    }

}


// ======================= End Podcast Api ======================//

}
