<?php $__env->startSection('title', 'Complaint'); ?>


<?php $__env->startSection('content'); ?>

    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>

            <?php if($message = Session::get('success')): ?>
                <div class="alert alert-success alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong><?php echo e($message); ?></strong>
                </div>
            <?php endif; ?>
            <?php if($message = Session::get('delete')): ?>
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong><?php echo e($message); ?></strong>
                </div>
            <?php endif; ?>

            <div class="row mb-10">
                <div class="col-md-6">
                    <figure class="highcharts-figure">
                    <div id="container7"></div>
                    </figure>
                </div>
                <div class="col-md-6">
                    <figure class="highcharts-figure">
                    <div id="container8"></div>
                    </figure>
                </div>
            </div>
            <br>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h3>Complaint Management</h3>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Category</th>
                                    <!-- <th>Police station</th>
                                    <th>Tehsil</th>
                                    <th>District</th>
                                    <th>Union council</th> -->
                                    <th>Evidence</th>
                                    <th>Priority</th>
                                    <th>Status</th>
                                    <th>Sub admin</th>
                                    <th>Complaint by</th>
                                    <th>Submission date</th>
                                    <th style="width: 250px">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($user->id); ?></td>
                                        <td><?php echo e($user->title); ?></td>
                                        <td><?php echo e($user->description); ?></td>
                                        <td><?php echo e($user->category->name); ?></td>
                                        <!-- <td><?php echo e($user->police_station); ?></td>
                                        <td><?php echo e($user->tehsil); ?></td>
                                        <td><?php echo e($user->district); ?></td>
                                        <td><?php echo e($user->union_council); ?></td> -->
                                        <td>
                                            <?php $photo = json_decode($user->photo);?>
                                            <?php if($photo): ?>
                                            <ul class="list-inline">
                                                <li data-toggle="modal" data-target="#myModal<?php echo e($user->id); ?>">
                                                    <a href="#myGallery<?php echo e($user->id); ?>" data-slide-to="0">
                                                        View Image
                                                    </a>
                                                </li>
                                            </ul>
                                            <div class="modal fade" id="myModal<?php echo e($user->id); ?>">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <div class="pull-left"><?php echo e($user->title); ?></div>
                                                                <button type="button" class="close" data-dismiss="modal"
                                                                        title="Close"><span
                                                                        class="glyphicon glyphicon-remove"></span></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <!--CAROUSEL CODE GOES HERE-->
                                                                <!--begin carousel-->
                                                                <div id="myGallery<?php echo e($user->id); ?>" class="carousel slide"
                                                                    data-interval="false">
                                                                    <div class="carousel-inner">
                                                                        <?php if($photo): ?>
                                                                            <?php $__currentLoopData = $photo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <div
                                                                                    class="item <?= $key == 0 ? 'active' : '';?>">
                                                                                    <img class="center"
                                                                                         style="width:100%"
                                                                                         src="<?php echo e(asset('/assets/uploads/'.$image)); ?>"
                                                                                         alt="item0">
                                                                                </div>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php endif; ?>
                                                                    <!--end carousel-inner-->
                                                                    </div>
                                                                    <!--Begin Previous and Next buttons-->
                                                                    <a class="left carousel-control"
                                                                       href="#myGallery<?php echo e($user->id); ?>" role="button"
                                                                       data-slide="prev"> <span
                                                                            class="glyphicon glyphicon-chevron-left"></span></a>
                                                                    <a class="right carousel-control"
                                                                       href="#myGallery<?php echo e($user->id); ?>" role="button"
                                                                       data-slide="next"> <span
                                                                       class="glyphicon glyphicon-chevron-right"></span></a>
                                             <!--end carousel--></div>
                                        <!--end modal-body--></div>
                                <!--end modal-content--></div>
                            <!--end modal-dialoge--></div>
                                                    <!--end myModal-->>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($user->priority); ?></td>
                                        <td> <?php if($user->status_id == 1): ?>
                                                <button type="button" class="btn btn-round btn-primary"> <?php echo e($user->status->name); ?> </button>
                                                <?php elseif($user->status_id == 3): ?>
                                                <button type="button" class="btn btn-round btn-primary"> <?php echo e($user->status->name); ?> </button>
                                                <?php elseif($user->status_id == 4): ?>
                                                <button type="button" class="btn btn-round btn-warning"> <?php echo e($user->status->name); ?> </button>
                                                <?php elseif($user->status_id == 5): ?>
                                                <button type="button" class="btn btn-round btn-primary"> <?php echo e($user->status->name); ?> </button>
                                                <?php elseif($user->status_id == 6): ?>
                                                <button type="button" class="btn btn-round btn-danger"> <?php echo e($user->status->name); ?> </button>
                                                <?php endif; ?>
                                        </td>
                                        <td><?php echo e($user->subadmin->name); ?></td>
                                        <td><?php echo e($user->user->name); ?></td>
                                        <td><?php echo e(date("l | dS F, Y g:i A",strtotime($user->create))); ?></td>
                                        <td>
                                            <a class="btn btn-info"
                                               href="<?php echo e(route('complaint.show',$user->id)); ?>">Show</a>
                                            <?php if(($user->status_id ==1)): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit')): ?>
                                                <a class="btn btn-primary showModal"
                                                   href="#" data-id="<?php echo e($user->id); ?>">Assign complaint</a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete')): ?>
                                                <?php echo Form::open(['method' => 'DELETE','route' => ['complaint.destroy', $user->id],'style'=>'display:inline']); ?>

                                                <?php echo Form::submit('Reject complaint', ['class' => 'btn btn-danger']); ?>

                                                <?php echo Form::close(); ?>

                                            <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="exampleModalLabel">Complaint Response</h4>
                    </div>
                    <div class="modal-body">
                        <?php echo Form::open(['method' => 'POST','accept-charset' => "UTF-8" ,'role' => 'form' ,
                           'enctype' => 'multipart/form-data' , 'data-parsley-validate' , 'id' => 'demo-form2',
                            'class' => 'form-horizontal form-label-left','route' => 'complaint.assign']); ?>


                        <input type="hidden" name="complaint_id" id="complaint_id" value="">
                        <?php echo csrf_field(); ?>
                        <div class="form-group <?php echo e(($errors->has('priorty')) ? 'has-error' : ''); ?>">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Priority <span
                                    class="required">*</span>
                            </label>
                            <div class="col-md-6 col-sm-6 col-xs-12">
                                <?php echo Form::select('priority',$priority,null, array('class' => 'select2_single form-control col-md-7 col-xs-12','required' =>'required')); ?>

                            </div>
                            <?php echo ($errors->has('priority') ? $errors->first('priority', '<p class="text-danger">:message</p>') : ''); ?>

                        </div>

                        <div class="form-group <?php echo e(($errors->has('status_id')) ? 'has-error' : ''); ?>" style="display:none">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Status <span
                                    class="required">*</span>
                            </label>
                            <div class="col-md-6 col-sm-6 col-xs-12">
                                <?php echo Form::select('status_id',$status, '3', array('class' => 'select2_single form-control col-md-7 col-xs-12','required' =>'required')); ?>

                            </div>
                            <?php echo ($errors->has('status_id') ? $errors->first('status_id', '<p class="text-danger">:message</p>') : ''); ?>

                        </div>

                        <div class="form-group <?php echo e(($errors->has('sub_admin_id')) ? 'has-error' : ''); ?>">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Sub Admin <span
                                    class="required">*</span>
                            </label>
                            <div class="col-md-6 col-sm-6 col-xs-12">
                                <?php echo Form::select('sub_admin_id',$users,null, array('class' => 'select2_single form-control col-md-7 col-xs-12','required' =>'required')); ?>

                            </div>
                            <?php echo ($errors->has('sub_admin_id') ? $errors->first('sub_admin_id', '<p class="text-danger">:message</p>') : ''); ?>

                        </div>

                        <div class="form-group <?php echo e(($errors->has('response')) ? 'has-error' : ''); ?>">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Response
                                <span
                                    class="required">*</span>
                            </label>
                            <div class="col-md-6 col-sm-6 col-xs-12">
                                <?php echo Form::textarea('response', null, array('placeholder' => 'Response','class' => 'form-control col-md-7 col-xs-12' , 'rows' => '3','required' =>'required')); ?>

                            </div>
                            <?php echo ($errors->has('response') ? $errors->first('response', '<p class="text-danger">:message</p>') : ''); ?>

                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>

Highcharts.chart('container8', {
    chart: {
        plotBackgroundColor: null,
        plotBorderWidth: null,
        plotShadow: false,
        type: 'pie'
    },
    title: {
        text: 'Complaint by status'
    },
    tooltip: {
        pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
    },
    accessibility: {
        point: {
            valueSuffix: ''
        }
    },
    plotOptions: {
        pie: {
            allowPointSelect: true,
            cursor: 'pointer',
            dataLabels: {
                enabled: false
            },
            showInLegend: true
        }
    },
    series: [{
        name: 'Status',
        colorByPoint: true,
        data: [
            <?php foreach($status_all as $s) { ?>
            {
                name: "<?php echo $s['id'] ?>",
                y: <?php echo $s['count'] ?>,
            },
            <?php } ?>
        ]
    }]
});

Highcharts.chart('container7', {
    chart: {
        plotBackgroundColor: null,
        plotBorderWidth: null,
        plotShadow: false,
        type: 'pie'
    },
    title: {
        text: 'Complaint by category'
    },
    tooltip: {
        pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
    },
    accessibility: {
        point: {
            valueSuffix: ''
        }
    },
    plotOptions: {
        pie: {
            allowPointSelect: true,
            cursor: 'pointer',
            dataLabels: {
                enabled: false
            },
            showInLegend: true
        }
    },
    series: [{
        name: 'Category',
        colorByPoint: true,
        data: [
            <?php foreach($catgory as $c) { ?>
            {
                name: "<?php echo $c['id'] ?>",
                y: <?php echo $c['count'] ?>,
            },
            <?php } ?>
            ]
    }]
});
        $(document).ready(function () {
            $('#datatable1').DataTable({
                "order": [[0, "desc"]]
            });

            $('.showModal').on('click', function () {
                var id = $(this).attr('data-id');
                console.log(id)
                $('#complaint_id').val(id)
                $('#exampleModal').modal('show');
            });

        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shaapngc/sophianaqvi.listen2me.biz/resources/views/complaint/index.blade.php ENDPATH**/ ?>