<?php $__env->startSection('content'); ?>
    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>
            <?php if($message = Session::get('success')): ?>
                <div class="alert alert-success alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong><?php echo e($message); ?></strong>
                </div>
            <?php endif; ?>
            <?php if($message = Session::get('delete')): ?>
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong><?php echo e($message); ?></strong>
                </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create')): ?>
                            <a class="nav navbar-right" href="<?php echo e(route('newfeed.create')); ?>">
                                <button type="button" class="btn btn-primary"><span class="glyphicon glyphicon-plus"
                                                                                    aria-hidden="true"></span>Create New
                                    New Feed
                                </button>
                            </a>
                        <?php endif; ?>
                        <div class="x_title">
                            <h3>New Feed Management</h3>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Video</th>
                                    <th>Status</th>
                                    <th>Submission date</th>
                                    <th width="280px">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($d->id); ?></td>
                                        <td><?php echo e($d->title); ?></td>
                                        <td><?php echo e($d->description); ?></td>
                                        <td>
                                        <?php if($d->image!=''): ?>
                                        <a href="<?php echo e(asset('/assets/uploads/'.$d->image)); ?>" target="_blank">
                                                <img src="<?php echo e(asset('/assets/uploads/'.$d->image)); ?>" alt="no image" height="50px" width="50px"/></a>
                                         <?php endif; ?>
                                                </td>
                                        <td>
                                        <?php if($d->video!=''): ?>
                                            <a href="<?php echo e(asset('/assets/uploads/'.$d->video)); ?>" target="_blank">
                                                <video width="200" controls>
                                                    <source src="<?php echo e(asset('/assets/uploads/'.$d->video)); ?>" type="video/mp4">
                                                </video>
                                            </a>
                                        <?php endif; ?> 
                                        </td>
                                        <td><?php echo e($d->status); ?></td>
                                        <td><?php echo e(date("l | dS F, Y g.i A",strtotime($d->create))); ?></td>
                                        <td>
                                            <?php if($d->status=='Active'): ?>
                                                <a data-toggle="tooltip" data-placement="bottom" title=""
                                                   data-original-title="Disable" class='btn btn-warning'
                                                   href="<?php echo e(route('newfeed.disable',$d->id)); ?>">Disable</a>
                                            <?php elseif($d->status=='Disable'): ?>
                                                <a data-toggle="tooltip" data-placement="bottom" title=""
                                                   data-original-title="Activate" class='btn btn-success'
                                                   href="<?php echo e(route('newfeed.activate',$d->id)); ?>">Activate</a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit')): ?>
                                                <a class="btn btn-primary"
                                                   href="<?php echo e(route('newfeed.edit',$d->id)); ?>">Edit</a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete')): ?>
                                                <?php echo Form::open(['method' => 'DELETE','route' => ['newfeed.destroy', $d->id],'style'=>'display:inline']); ?>

                                                <?php echo Form::submit('Delete', ['class' => 'btn btn-danger']); ?>

                                                <?php echo Form::close(); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function () {
            $('#datatable1').DataTable({
                "order": [[0, "desc"]]
            });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/merayijt/14digital.co.uk/pp67/resources/views/newfeed/index.blade.php ENDPATH**/ ?>