<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
});
Route::get('/jointhefight', [App\Http\Controllers\JoinTheFightController::class, 'create'])->name('jointhefight');
Route::post('/jointhefight/submit', [App\Http\Controllers\JoinTheFightController::class, 'store'])->name('jointhefight.store');
Route::resource('support', App\Http\Controllers\DonationController::class);
Route::get('/privacypolicy', [App\Http\Controllers\Auth\LoginController::class, 'privacypolicy'])->name('privacypolicy');
Route::get('/cookiepolicy', [App\Http\Controllers\Auth\LoginController::class, 'cookiepolicy'])->name('cookiepolicy');
Route::get('/contactus', [App\Http\Controllers\Auth\LoginController::class, 'contactus'])->name('contactus');
Route::POST('/savecontact', [App\Http\Controllers\Auth\LoginController::class, 'postContact'])->name('login.postcontact');
Route::get('/sharenewsfeed/{id}',[App\Http\Controllers\NewFeedController::class,'sharenewsfeed'])->name('sharenewsfeed');


Auth::routes();


Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::group(['middleware' => ['auth']], function() {
    Route::resource('roles', App\Http\Controllers\RoleController::class);
    Route::resource('users', App\Http\Controllers\UserController::class);
    Route::get('/subadmin/users', [App\Http\Controllers\UserController::class, 'subUser'])->name('subadmin.user');
    Route::get('/superadmin/users', [App\Http\Controllers\UserController::class, 'superadminUser'])->name('superadmin.user');
    Route::get('/superuser/users', [App\Http\Controllers\UserController::class, 'superuserUser'])->name('superuser.user');
    Route::get('/member/users', [App\Http\Controllers\UserController::class, 'memberUser'])->name('member.user');
    Route::get('/nmember/users', [App\Http\Controllers\UserController::class, 'nmemberUser'])->name('nmember.user');

    Route::post('/nmember/status', [App\Http\Controllers\UserController::class, 'nmemberStatus'])->name('nmember.status');

    Route::get('/my/users', [App\Http\Controllers\UserController::class, 'myUser'])->name('my.user');
    Route::get('/my/users/{id}', [App\Http\Controllers\UserController::class, 'myUserShow'])->name('myusers.show');
    Route::get('/my/users/edit/{id}', [App\Http\Controllers\UserController::class, 'myUserEdit'])->name('myusers.edit');
    // Route::get('/my/users', [App\Http\Controllers\UserController::class, 'myUser'])->name('my.user');

    Route::resource('categories', App\Http\Controllers\CategoryController::class);
    Route::resource('status', App\Http\Controllers\StatusControllerer::class);
    Route::resource('survey', App\Http\Controllers\SurveyController::class);
    Route::resource('announcement', App\Http\Controllers\AnnouncementController::class);
    Route::resource('place', App\Http\Controllers\PlaceController::class);
    Route::resource('memoir', App\Http\Controllers\MemoirController::class);
    Route::resource('gallery', App\Http\Controllers\GalleryController::class);
    Route::resource('newfeed', App\Http\Controllers\NewFeedController::class);
    Route::get('newfeed/activate/{activate}', [App\Http\Controllers\NewFeedController::class, 'activate'])->name('newfeed.activate');
    Route::get('newfeed/disable/{disable}', [App\Http\Controllers\NewFeedController::class, 'disable'])->name('newfeed.disable');

    Route::resource('aboutme', App\Http\Controllers\AboutMeController::class);
    Route::resource('complaint', App\Http\Controllers\ComplaintController::class);
    Route::get('/my/complaint', [App\Http\Controllers\ComplaintController::class, 'myComplaint'])->name('my.complaint');
    Route::post('/my/complaint/assign', [App\Http\Controllers\ComplaintController::class, 'myComplaintAssign'])->name('my.complaint.assign');
    Route::post('/complaint/assign', [App\Http\Controllers\ComplaintController::class, 'complaintAssign'])->name('complaint.assign');
    Route::resource('petition', App\Http\Controllers\PetitionController::class);

    Route::resource('dairy', App\Http\Controllers\DairyController::class);
    Route::post('/dairy/response', [App\Http\Controllers\DairyController::class, 'dairyResponse'])->name('dairy.response');

    Route::get('/supports', [App\Http\Controllers\DonationController::class, 'supportlist'])->name('supports');
    Route::get('/joinlist', [App\Http\Controllers\JoinTheFightController::class, 'index'])->name('joinlist');

    

});

