<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ApiController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
Route::post('/signup',[ApiController::class,'signup']);
Route::post('/verification',[ApiController::class,'verificationcode']);

Route::post('/forgotpassword',[ApiController::class,'forgotPassword']);
Route::post('/loginbycnic',[ApiController::class,'loginByCnic']);
Route::post('/loginbyemail',[ApiController::class,'loginByEmail']);
Route::post('/profileregistraion',[ApiController::class,'profileregistraion']);
//Route::post('/sendnotification',[ApiController::class,'sendnotification']);
Route::post('/resendcode',[ApiController::class,'resendverificationcode']);

Route::post('/get/places',[ApiController::class,'getPlaces']);

Route::group(['middleware' => ['auth:sanctum']],function(){

    Route::get('/category',[ApiController::class,'category']);


    Route::post('/deluser',[ApiController::class,'deleteuser']);
    Route::post('/profilepic',[ApiController::class,'uploadprofilepic']);
    Route::get('/profilepic',[ApiController::class,'getprofilepic']);

    Route::get('/profile',[ApiController::class,'profile']);
    Route::put('/profileupdate',[ApiController::class,'profileUpdate']);
    Route::put('/password',[ApiController::class,'updatePassword']);


    Route::post('/complaint',[ApiController::class,'addComplaint']);
    Route::get('/complaint/{id}',[ApiController::class,'showComplaint']);
    Route::get('/allcomplaints',[ApiController::class,'allComplaints']);
    Route::get('/complaintresponse/{id}',[ApiController::class,'getComplaintResponse']);
    Route::post('/addcomplaintresponse',[ApiController::class,'addcomplaintresponse']);

    Route::post('/petition',[ApiController::class,'addPetition']);
    Route::get('/petition/{id}',[ApiController::class,'showPetition']);
    Route::get('/allpetitions',[ApiController::class,'allPetitions']);
    Route::get('/petitionvote',[ApiController::class,'petitionvote']);
    Route::post('/agreepetition',[ApiController::class,'agreepetition']);
    Route::post('/withdrawmysupport',[ApiController::class,'withdrawmysupport']);

    Route::get('/submittedcomplaints/{id}',[ApiController::class,'submittedcomplaints']);
    Route::get('/pendingcomplaints/{id}',[ApiController::class,'pendingcomplaints']);
    Route::get('/resolvedcomplaints/{id}',[ApiController::class,'resolvedcomplaints']);
    Route::get('/inreviewcomplaints/{id}',[ApiController::class,'inreviewcomplaints']);

    Route::get('/allcomplaintstatus',[ApiController::class,'allcomplaintstatus']);
    Route::get('/mycomplaintstatus',[ApiController::class,'mycomplaintstatus']);

    Route::get('/surveys',[ApiController::class,'survey']);
    Route::post('/surveyvote',[ApiController::class,'surveyvote']);

    Route::get('/announcements',[ApiController::class,'announcement']);
    Route::get('/gallery',[ApiController::class,'gallery']);

    Route::post('savenewsfeed',[ApiController::class,'savenewsfeed']);
    Route::get("/allnewsfeed",[ApiController::class,'allnewsfeed']);
    Route::get("/newsfeed/{id}",[ApiController::class,'newsfeedbyid']);
    Route::get("/mynewsfeed/{userid}",[ApiController::class,'mynewsfeed']);
    Route::post('/addnewsfeedlike',[ApiController::class,'addnewsfeedlike']);

     Route::post('sharenewsfeed',[ApiController::class,'sharenewsfeed']);

    Route::get("/mpnewsfeed",[ApiController::class,'mpnewsfeed']);
    Route::get('/mpnewsfeed/{id}',[ApiController::class,'mpnewsfeedbyid']);

    Route::get("/allcondolences",[ApiController::class,'allcondolences']);
    Route::get("/condolences/{id}",[ApiController::class,'getcondolencesbyid']);

    Route::get("/aboutme",[ApiController::class,'aboutme']);

    Route::post('/uploadgallery',[ApiController::class,'uploadgallery']);

    Route::post('/contactme',[ApiController::class,'contactme']);



    Route::get("/notificationList",[ApiController::class,'notificationList']);
    Route::post('/notificationRead',[ApiController::class,'notificationRead']);


    Route::post('/logout',[ApiController::class,'logout']);


});

