<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ApiController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/




Route::post('/surveys',[ApiController::class,'survey']);
Route::post('/surveyvote',[ApiController::class,'surveyvote']);
Route::get('/announcements',[ApiController::class,'announcement']);
Route::get('/gallery',[ApiController::class,'gallery']);
Route::post('/uploadgallery',[ApiController::class,'uploadgallery']);
Route::post('sharenewsfeed',[ApiController::class,'sharenewsfeed']);
Route::get("/aboutme",[ApiController::class,'aboutme']);
Route::post('/uploadgallery',[ApiController::class,'uploadgallery']);
Route::post('/contactme',[ApiController::class,'contactme']);
Route::get("/notificationList",[ApiController::class,'notificationList']);
Route::post('/notificationRead',[ApiController::class,'notificationRead']);
Route::post('/jointhefight',[ApiController::class,'jointhefight']);
Route::get("/allnewsfeed",[ApiController::class,'allnewsfeed']);
Route::post('savenewsfeed',[ApiController::class,'savenewsfeed']);
Route::get("/newsfeed/{id}",[ApiController::class,'newsfeedbyid']);
Route::get("/mynewsfeed/{device_id}",[ApiController::class,'mynewsfeed']);
Route::post("/mpnewsfeed",[ApiController::class,'mpnewsfeed']);
Route::get('/mpnewsfeed/{id}',[ApiController::class,'mpnewsfeedbyid']);
Route::post('/addnewsfeedlike',[ApiController::class,'addnewsfeedlike']);


//============================Admin Panel ================================//

Route::post('/loginbyemail',[ApiController::class,'loginByEmail']);
Route::group(['middleware' => ['auth:sanctum']],function(){
    Route::post('/addsurvey',[ApiController::class,'addsurvey']);
    Route::put('/modifysurvey/{id}',[ApiController::class,'modifysurvey']);
    Route::delete('/delsurvey/{id}',[ApiController::class,'deletesurvey']);

    Route::post('/addannouncement',[ApiController::class,'addannouncement']);
    Route::put('/modifyannouncement/{id}',[ApiController::class,'modifyannouncement']);
    Route::delete('/delannouncement/{id}',[ApiController::class,'deleteannouncement']);

    Route::post('/addnewsfeed',[ApiController::class,'addnewsfeed']);
    Route::put('/modifynewsfeed/{id}',[ApiController::class,'modifynewsfeed']);
    Route::delete('/deletenewsfeed/{id}',[ApiController::class,'deletenewsfeed']);
    Route::put('/disablenewsfeed/{id}',[ApiController::class,'disablenewsfeed']);

    Route::get('/support',[ApiController::class,'supportmanagement']);

    Route::post('/addgallery',[ApiController::class,'addgallery']);
    Route::delete('/deletegallery/{id}',[ApiController::class,'deletegallery']);

    // Route::get('/aboutme',[ApiController::class,'aboutme']);
    // Route::put('/modifyaboutme/{id}',[ApiController::class,'modifyaboutme']);



});