<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ApiController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('/surveys',[ApiController::class,'survey']);
Route::post('/surveyvote',[ApiController::class,'surveyvote']);
Route::get('/announcements',[ApiController::class,'announcement']);
Route::get('/gallery',[ApiController::class,'gallery']);
Route::post('/uploadgallery',[ApiController::class,'uploadgallery']);
Route::post('sharenewsfeed',[ApiController::class,'sharenewsfeed']);
Route::get("/aboutme",[ApiController::class,'aboutme']);
Route::post('/uploadgallery',[ApiController::class,'uploadgallery']);
Route::post('/contactme',[ApiController::class,'contactme']);
Route::get("/notificationList",[ApiController::class,'notificationList']);
Route::post('/notificationRead',[ApiController::class,'notificationRead']);
Route::post('/jointhefight',[ApiController::class,'jointhefight']);
Route::get("/allnewsfeed",[ApiController::class,'allnewsfeed']);
Route::post('savenewsfeed',[ApiController::class,'savenewsfeed']);
Route::get("/newsfeed/{id}",[ApiController::class,'newsfeedbyid']);
Route::get("/mynewsfeed/{device_id}",[ApiController::class,'mynewsfeed']);
Route::post("/mpnewsfeed",[ApiController::class,'mpnewsfeed']);
Route::get('/mpnewsfeed/{id}',[ApiController::class,'mpnewsfeedbyid']);
Route::post('/addnewsfeedlike',[ApiController::class,'addnewsfeedlike']);

//========================= Podcast Api ======================================//
Route::post('/create/podcast',[ApiController::class,'createPodcast']);
Route::post('/agoratoken',[ApiController::class,'agoraToken']);
Route::post('/join/audience',[ApiController::class,'joinaudience']);
Route::post('/leave/podcast',[ApiController::class,'leavePodcast']);
Route::get('/stream/podcast',[ApiController::class,'streampodcast']);
Route::get('/delete/podcast/{id}',[ApiController::class,'deletepodcast']);
Route::get('/live/podcast',[ApiController::class,'livepodcast']);
//========================  End Podcast Api ==================================//

// ====================Cloud Recording Api Routes =====================//
Route::post('/acquire',[ApiController::class,'acquire']);
Route::post('/start',[ApiController::class,'start']);
Route::post('/query',[ApiController::class,'query']);
Route::post('/stop',[ApiController::class,'stop']);

Route::post('/recordingstatus',[ApiController::class,'recordingstatus'])->name('recordingstatus');
//=======================End Cloud Recording APi Routes ==============//


//================================Instagramp post Api =======================================//
Route::post('/instanewsfeed',[ApiController::class,'instanewsfeed'])->name('instanewsfeed');
//============================================================================================//



//============================Admin Panel ================================//
Route::post('user/status',[ApiController::class,'userStatus']);
Route::post('/loginbyemail',[ApiController::class,'loginByEmail']);
Route::group(['middleware' => ['auth:sanctum']],function(){
    Route::post('/addsurvey',[ApiController::class,'addsurvey']);
    Route::put('/modifysurvey/{id}',[ApiController::class,'modifysurvey']);
    Route::delete('/delsurvey/{id}',[ApiController::class,'deletesurvey']);

    Route::post('/addannouncement',[ApiController::class,'addannouncement']);
    Route::put('/modifyannouncement/{id}',[ApiController::class,'modifyannouncement']);
    Route::delete('/delannouncement/{id}',[ApiController::class,'deleteannouncement']);

    Route::post('/addnewsfeed',[ApiController::class,'addnewsfeed']);
    Route::post('/modifynewsfeed/{id}',[ApiController::class,'modifynewsfeed']);
    Route::delete('/deletenewsfeed/{id}',[ApiController::class,'deletenewsfeed']);
    Route::put('/disablenewsfeed/{id}',[ApiController::class,'disablenewsfeed']);

    Route::get('/support',[ApiController::class,'supportmanagement']);

    Route::post('/addgallery',[ApiController::class,'addgallery']);
    Route::delete('/deletegallery/{id}',[ApiController::class,'deletegallery']);

    // Route::get('/aboutme',[ApiController::class,'aboutme']);
    Route::post('/modifyaboutme/{id}',[ApiController::class,'modifyaboutme']);

    Route::get('/surveylist',[ApiController::class,'surveylist']);
    Route::get('/newsfeedlist',[ApiController::class,'newsfeedlist']);

    Route::get('/jointhefightlist',[ApiController::class,'jointhefightlist']);

    Route::get('contactuslist',[ApiController::class,'contactuslist']);
    
    Route::post('make/admin/user',[ApiController::class,'makeadminuser']);


});