@extends('layouts.app')
@section('title', 'Users')


@section('content')

    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>
            @if($message = Session::get('success'))
                <div class="alert alert-success alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            @if($message = Session::get('delete'))
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif


            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        @can('create')
                            <a class="nav navbar-right" href="{{ route('users.create') }}">

                                <button type="button" class="btn btn-primary"><span class="glyphicon glyphicon-plus"
                                                                                    aria-hidden="true"></span>Create New
                                    User
                                </button>
                                
                                
                            </a>
                        <form action="{{ route('nmember.status') }}" method="post" id="myForm">
                            <input type="hidden" id="complaint_id" name="complaint_id">
                            @csrf
                            <button class="nav navbar-right btn btn-info" id="save-c" style="margin-right:10px" type="button" >&nbsp;Click here to verify</button>
                        </form>
                            
                        @endcan

                        <div class="x_title">
                            <h3>User Management</h3>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th><input type="checkbox" value="" class="master" name="select-all" id="select-all" /></th>
                                    <th>No</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Cnic#</th>
                                    <th>Cnic Front Image</th>
                                    <th>Cnic Back Image</th>
                                   <!-- <th>Tehsil</th>
                                    <th>District</th>
                                    <th>Union council</th>-->
                                    <th>Submission date</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($data as $key => $user)
                                    <tr>
                                        <td><input type="checkbox" class="checkbox" value="{{ $user->id }}" /></td>
                                        <td>{{ $user->id }}</td>
                                        <td>{{ $user->name }}</td>
                                        <td>{{ $user->email }}</td>
                                        <td>{{ $user->id_no }}</td>
                                        <td>
                                        @if($user->id_front!='')
                                        <a href="{{ asset('/assets/uploads/'.$user->id_front) }}" target="_blank"> <img alt="#" src="{{asset('/assets/uploads/'.$user->id_front)}}" height="50px"
                                               width="50px"/></a>
                                        @endif
                                        </td>
                                        <td>
                                        @if($user->id_back!='')
                                        <a href="{{ asset('/assets/uploads/'.$user->id_back) }}" target="_blank"> <img alt="#" src="{{asset('/assets/uploads/'.$user->id_back)}}" height="50px"
                                                 width="50px"/></a>
                                        @endif
                                        </td>
                                     <!--   <td>{{ $user->tehsil }}</td>
                                        <td>{{ $user->district }}</td>
                                        <td>{{ $user->union_council }}</td>-->
                                        <td>{{ date("l | dS F, Y g:i A",strtotime($user->create)) }}</td>
                                        <td>
                                            <a class="btn btn-info" href="{{ route('users.show',$user->id) }}">Show</a>
                                            @can('edit')
                                                <a class="btn btn-primary"
                                                   href="{{ route('users.edit',$user->id) }}">Edit</a>
                                            @endcan
                                            @can('delete')
                                                {!! Form::open(['method' => 'DELETE','route' => ['users.destroy', $user->id],'style'=>'display:inline']) !!}
                                                {!! Form::submit('Delete', ['class' => 'btn btn-danger']) !!}
                                                {!! Form::close() !!}
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>


@endsection
@section('script')
<script>
    $(document).ready(function() {
    // Setup - add a text input to each footer cell
    $('#datatable1 thead tr').clone(true).appendTo( '#datatable1 thead' );
    $('#datatable1 thead tr:eq(1) th').each( function (i) {
        var title = $(this).text();
        $(this).html( '<input type="text" placeholder="Search '+title+'" />' );
 
        $( 'input', this ).on( 'keyup change', function () {
            if ( table.column(i).search() !== this.value ) {
                table
                    .column(i)
                    .search( this.value )
                    .draw();
            }
        } );
    } );
 
    var table = $('#datatable1').DataTable( {
        // orderCellsTop: true,
        columnDefs: [
            { orderable: false, targets: 0 }
          ],
        // fixedHeader: true
    } );
} );

$('#select-all').click(function(event) {   
    if(this.checked) {
        // Iterate each checkbox
        $(':checkbox').each(function() {
            this.checked = true;                        
        });
    } else {
        $(':checkbox').each(function() {
            this.checked = false;                       
        });
    }
});

$(function(){
    $('#save-c').click(function(){
        var val = [];
        $('.checkbox:checked').each(function(i){
            if($(this).val() != '' && $(this).val() != null){
                val[i] = $(this).val();
            }
        });
        
        if (val === undefined || val.length == 0) {
            alert('Select the complaint you want to veriy')
        }else{
            $('#complaint_id').val(val)
            $("#myForm").submit();
        }
        
        
    });
});
</script>
@endsection
