@extends('layouts.app')
@section('title', 'Complaint')


@section('content')

    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>

            @if($message = Session::get('success'))
                <div class="alert alert-success alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            @if($message = Session::get('delete'))
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif

            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h3>Petition Management</h3>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Category</th>
                                    <!-- <th>Police station</th>
                                    <th>Tehsil</th>
                                    <th>District</th>
                                    <th>Union council</th> -->
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th>Petition by</th>
                                    <th>Submission date</th>
                                    <th style="width: 250px">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($data as $key => $user)
                                    <tr>
                                        <td>{{ $user->id }}</td>
                                        <td>{{ $user->title }}</td>
                                        <td>{{ $user->description }}</td>
                                        <td>{{ $user->category->name }}</td>
                                        <!-- <td>{{ $user->police_station }}</td>
                                        <td>{{ $user->tehsil }}</td>
                                        <td>{{ $user->district }}</td>
                                        <td>{{ $user->union_council }}</td> -->
                                        <td>
                                            <?php $photo = json_decode($user->photo);?>
                                            @if($photo)
                                            <ul class="list-inline">
                                                <li data-toggle="modal" data-target="#myModal{{$user->id}}">
                                                    <a href="#myGallery{{$user->id}}" data-slide-to="0">
                                                        View Image
                                                    </a>
                                                </li>
                                            </ul>
                                            <div class="modal fade" id="myModal{{$user->id}}">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <div class="pull-left">{{$user->title}}</div>
                                                                <button type="button" class="close" data-dismiss="modal"
                                                                        title="Close"><span
                                                                        class="glyphicon glyphicon-remove"></span></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <!--CAROUSEL CODE GOES HERE-->
                                                                <!--begin carousel-->
                                                                <div id="myGallery{{$user->id}}" class="carousel slide"
                                                                    data-interval="false">
                                                                    <div class="carousel-inner">
                                                                        @if($photo)
                                                                            @foreach($photo as $key=>$image)
                                                                                <div
                                                                                    class="item <?= $key == 0 ? 'active' : '';?>">
                                                                                    <img class="center"
                                                                                         style="height:100%;width:100%"
                                                                                         src="{{  asset('/assets/uploads/'.$image) }}"
                                                                                         alt="item0">
                                                                                </div>
                                                                            @endforeach
                                                                        @endif
                                                                    <!--end carousel-inner-->
                                                                    </div>
                                                                    <!--Begin Previous and Next buttons-->
                                                                    <a class="left carousel-control"
                                                                       href="#myGallery{{$user->id}}" role="button"
                                                                       data-slide="prev"> <span
                                                                            class="glyphicon glyphicon-chevron-left"></span></a>
                                                                    <a class="right carousel-control"
                                                                       href="#myGallery{{$user->id}}" role="button"
                                                                       data-slide="next"> <span
                                                                       class="glyphicon glyphicon-chevron-right"></span></a>
                                             <!--end carousel--></div>
                                        <!--end modal-body--></div>
                                <!--end modal-content--></div>
                            <!--end modal-dialoge--></div>
                                                    <!--end myModal-->>
                                                </div>
                                            @endif
                                        </td>
                                        <td>@if($user->status_id == 3)
                                        <button type="button" class="btn btn-round btn-info"> {{ $user->status->name }} </button>
                                        @elseif($user->status_id == 1)
                                        <button type="button" class="btn btn-round btn-success"> {{ $user->status->name }} </button>
                                        @elseif($user->status_id == 6)
                                        <button type="button" class="btn btn-round btn-danger"> {{ $user->status->name }} </button>
                                        @endif </td>
                                        <td>{{ $user->user->name }}</td>
                                        <td>{{ date("l | dS F, Y g:i A",strtotime($user->create)) }}</td>
                                        <td>
                                            <a class="btn btn-info"
                                               href="{{ route('petition.show',$user->id) }}">Show</a>
                                            @if($user->status->id !=1)
                                            @if($user->status->id != 6)
                                            @can('edit')
                                                {!! Form::open(['method' => 'DELETE','route' => ['petition.destroy',$user->id."_a"],'style'=>'display:inline']) !!}
                                                {!! Form::submit('Approve petition', ['class' => 'btn btn-primary']) !!}

                                                {!! Form::close() !!}
                                            @endcan


                                            @can('delete')
                                                {!! Form::open(['method' => 'DELETE','route' => ['petition.destroy', $user->id."_d"],'style'=>'display:inline']) !!}
                                                {!! Form::submit('Reject petition', ['class' => 'btn btn-danger']) !!}

                                                {!! Form::close() !!}
                                            @endcan
                                            @endif
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function () {
            $('#datatable1').DataTable({
                "order": [[0, "desc"]]
            });
        });
    </script>
@endsection

