@extends('layouts.app')


@section('content')

    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>

            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br><br>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Create New Gallery</h2>
                            <div class="pull-right">
                                <a class="btn btn-primary" href="{{ route('gallery.index') }}"> Back</a>
                            </div>

                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <br/>
                            {!! Form::open(['method' => 'POST','accept-charset' => "UTF-8" ,'role' => 'form' ,
                            'enctype' => 'multipart/form-data' , 'data-parsley-validate' , 'id' => 'demo-form2',
                             'class' => 'form-horizontal form-label-left','route' => 'gallery.store']) !!}

                            <div class="form-group {{ ($errors->has('title')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Title <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::text('title', null, array('placeholder' => 'Title','class' => 'form-control')) !!}
                                </div>
                                {!! ($errors->has('title') ? $errors->first('title', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('address')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Address
                                    <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::textarea('address',null, array('placeholder' => 'Address','class' => 'form-control col-md-7 col-xs-12' , 'rows' => '3')) !!}
                                </div>
                                {!! ($errors->has('address') ? $errors->first('address', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="form-group {{ ($errors->has('images')) ? 'has-error' : '' }}">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Image <span
                                        class="required">*</span>
                                </label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    {!! Form::file('images',null, array('class' => 'form-control col-md-7 col-xs-12')) !!}
                                </div>
                                {!! ($errors->has('images') ? $errors->first('photo', '<p class="text-danger">:message</p>') : '') !!}
                            </div>

                            <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>

                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
