@extends('layouts.app')
@section('title', 'Complaint')


@section('content')

    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>

            @if($message = Session::get('success'))
                <div class="alert alert-success alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            @if($message = Session::get('delete'))
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            
            <div class="row mb-10">
                <div class="col-md-6">
                    <figure class="highcharts-figure">
                    <div id="container7"></div>
                    </figure>
                </div>
                <div class="col-md-6">
                    <figure class="highcharts-figure">
                    <div id="container8"></div>
                    </figure>
                </div>
            </div>
            <br>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        @can('create')
                            <a class="nav navbar-right" href="{{ route('dairy.create') }}">
                                <button type="button" class="btn btn-primary"><span class="glyphicon glyphicon-plus"
                                                                                    aria-hidden="true"></span>Create New
                                    Diary
                                </button>
                            </a>
                        @endcan
                        <div class="x_title">
                            <h3>Diary Management</h3>
                            <div class="clearfix"></div>
                        </div>
                        <div class="toolbar" style="margin-bottom:10px">
                                <div class="row"> <div class="col-md-6">
                                     From <input name="min" class="form-control" id="min" type="date" value="0">
                                </div>
                                <div class="col-md-6">To <input name="max" class="form-control" id="max" type="date" value="0"></div>
                                </div>
                                
                                <div class="row"> 
                                    <div class="col-md-6">
                                        <select class="form-control" id="priority" style="margin-top:10px">
                                            <option value="">Select Priority</option>
                                                @foreach($priority as $p)
                                                <option value="{{$p}}">{{$p}}</option>
                                                @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Priority</th>
                                    <th>Status</th>
                                    <th>Data</th>
                                    <th style="width: 250px">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($data as $key => $user)
                                    <tr>
                                        <td>{{ $user->id }}</td>
                                        <td>{{ $user->title }}</td>
                                        <td>{{ $user->description }}</td>
                                        <td>
                                        @if($user->image!='')
                                        <a href="{{ asset('/assets/uploads/'.$user->image) }}" target="_blank"> <img src="{{asset('/assets/uploads/'.$user->image)}}" height="50px"
                                               class="img-thumbnail" alt="not found"  width="50px"/></a>
                                        @endif       
                                        </td>
                                        <td>{{ $user->priority }}</td>
                                        <td>{{ $user->status }}</td>
                                        <td>{{ date("m-d-Y",strtotime($user->date_time)) }}</td>
                                        <td>
                                            <a class="btn btn-info"
                                               href="{{ route('dairy.show',$user->id) }}">Show</a>
                                             @can('edit')
                                              <a class="btn btn-warning"
                                                   href="{{ route('dairy.edit',$user->id) }}">Edit</a>
                                                @if($user->status != 'Complete')
                                                <a class="btn btn-primary showModal"
                                                   href="#" data-id="{{ $user->id }}">Comment</a>
                                                @endif
                                            @endcan
                                            @can('delete')
                                                {!! Form::open(['method' => 'DELETE','route' => ['dairy.destroy', $user->id],'style'=>'display:inline']) !!}
                                                {!! Form::submit('Remove Diary', ['class' => 'btn btn-danger']) !!}
                                                {!! Form::close() !!}
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="exampleModalLabel">Comment Response</h4>
                    </div>
                    <div class="modal-body">
                        {!! Form::open(['method' => 'POST','accept-charset' => "UTF-8" ,'role' => 'form' ,
                           'enctype' => 'multipart/form-data' , 'data-parsley-validate' , 'id' => 'demo-form2',
                            'class' => 'form-horizontal form-label-left','route' => 'dairy.response']) !!}
 @csrf
                        <input type="hidden" name="dairy_id" id="complaint_id" value="">
                       
                        
                        <!--<div class="form-group {{ ($errors->has('status_id')) ? 'has-error' : '' }}">-->
                        <!--    <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Status <span-->
                        <!--            class="required">*</span>-->
                        <!--    </label>-->
                        <!--    <div class="col-md-6 col-sm-6 col-xs-12">-->
                        <!--        {!! Form::select('status_id',array('Pending' => 'Pending', 'Complete' => 'Complete'), 'Pending', array('class' => 'select2_single form-control col-md-7 col-xs-12','required' =>'required')) !!}-->
                        <!--    </div>-->
                        <!--    {!! ($errors->has('status_id') ? $errors->first('status_id', '<p class="text-danger">:message</p>') : '') !!}-->
                        <!--</div>-->

                       
                        <div class="form-group {{ ($errors->has('response')) ? 'has-error' : '' }}">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Response
                                <span
                                    class="required">*</span>
                            </label>
                            <div class="col-md-6 col-sm-6 col-xs-12">
                                {!! Form::textarea('response', null, array('placeholder' => 'Response','class' => 'form-control col-md-7 col-xs-12' , 'rows' => '3','required' =>'required')) !!}
                            </div>
                            {!! ($errors->has('response') ? $errors->first('response', '<p class="text-danger">:message</p>') : '') !!}
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
        </div>

    </div>
@endsection
@section('script')
<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
    <script>
    // $("div.toolbar").html('');

  $.fn.dataTable.ext.search.push(
    function(settings, data, dataIndex) {
      var min_date = document.getElementById("min").value;
      var min = new Date(min_date);
      var max_date = document.getElementById("max").value;
      var max = new Date(max_date);
      var p = document.getElementById("priority").value;
      
      
      var priority = data[4] || 0;
      var startDate = new Date(data[6]);
      
      
      
      
    
        // console.log('priority', priority);
        // console.log('p', p);
       
    //   console.log('min', min);
    //   console.log('max', max);
    //   console.log('startDate', startDate);
      //window.confirm(startDate);
      if (!min_date && !max_date) {
        return true;
      }
      if (!min_date  && startDate <= max ) {
        return true;
      }
      if (!max_date && startDate >= min) {
        return true;
      }
      if (startDate <= max && startDate >= min) {
        return true;
      }
      return false;
    }
  );

  var table = $('#datatable1').DataTable({
      "order": [[6, "desc"]]
  });

          // Event listener to the two range filtering inputs to redraw on input
          $('#min, #max').change(function() {
            table.draw();
          });
  
  
        $( '#priority' ).on( 'change', function () {
			if ( table.columns(4).search() !== $( '#priority' ).val() ) {
				table.columns(4).search( $( '#priority' ).val() ).draw();
			}
		} );
  
  
        $(document).ready(function () {
            $('.showModal').on('click', function () {
                var id = $(this).attr('data-id');
                console.log(id)
                $('#complaint_id').val(id)
                $('#exampleModal').modal('show');
            });

        });
    </script>
@endsection

