@extends('layouts.app')
@section('title', 'Complaint')


@section('content')

    <div class="right_col" role="main">
        <div class="">
            <div class="clearfix"></div>

            @if($message = Session::get('success'))
                <div class="alert alert-success alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif
            @if($message = Session::get('delete'))
                <div class="alert alert-danger alert-block">
                    <button type="button" class="close" data-dismiss="alert">
                    </button>
                    <strong>{{$message}}</strong>
                </div>
            @endif


            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h3>Complaint Management</h3>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <table id="datatable1" class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Category</th>
                                    <!-- <th>Police station</th>
                                    <th>Tehsil</th>
                                    <th>District</th>
                                    <th>Union council</th> -->
                                    <th>Evidence</th>
                                    <th>Priority</th>
                                    <th>Status</th>
                                    <!--<th>Sub admin</th>-->
                                    <th>Complaint by</th>
                                    <th>Submission date</th>
                                    <th style="width: 250px">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($data as $key => $user)
                                    <tr>
                                        <td>{{ $user->id }}</td>
                                        <td>{{ $user->title }}</td>
                                        <td>{{ $user->description }}</td>
                                        <td>{{ $user->category->name }}</td>
                                        <!-- <td>{{ $user->police_station }}</td>
                                        <td>{{ $user->tehsil }}</td>
                                        <td>{{ $user->district }}</td>
                                        <td>{{ $user->union_council }}</td> -->
                                        <td>
                                        <?php $photo = json_decode($user->photo);?>
                                            @if($photo)
                                            <ul class="list-inline">
                                                <li data-toggle="modal" data-target="#myModal{{$user->id}}">
                                                    <a href="#myGallery{{$user->id}}" data-slide-to="0">
                                                        View Image
                                                    </a>
                                                </li>
                                            </ul>
                                            <div class="modal fade" id="myModal{{$user->id}}">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <div class="pull-left">{{$user->title}}</div>
                                                                <button type="button" class="close" data-dismiss="modal"
                                                                        title="Close"><span
                                                                        class="glyphicon glyphicon-remove"></span></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <!--CAROUSEL CODE GOES HERE-->
                                                                <!--begin carousel-->
                                                                <div id="myGallery{{$user->id}}" class="carousel slide"
                                                                    data-interval="false">
                                                                    <div class="carousel-inner">
                                                                        @if($photo)
                                                                            @foreach($photo as $key=>$image)
                                                                                <div
                                                                                    class="item <?= $key == 0 ? 'active' : '';?>">
                                                                                    <img class="center"
                                                                                         style="width:100%"
                                                                                         src="{{ asset('/assets/uploads/'.$image) }}"
                                                                                         alt="item0">
                                                                                </div>
                                                                            @endforeach
                                                                        @endif
                                                                    <!--end carousel-inner-->
                                                                    </div>
                                                                    <!--Begin Previous and Next buttons-->
                                                                    <a class="left carousel-control"
                                                                       href="#myGallery{{$user->id}}" role="button"
                                                                       data-slide="prev"> <span
                                                                            class="glyphicon glyphicon-chevron-left"></span></a>
                                                                    <a class="right carousel-control"
                                                                       href="#myGallery{{$user->id}}" role="button"
                                                                       data-slide="next"> <span
                                                                       class="glyphicon glyphicon-chevron-right"></span></a>
                                             <!--end carousel--></div>
                                        <!--end modal-body--></div>
                                <!--end modal-content--></div>
                            <!--end modal-dialoge--></div>
                                                    <!--end myModal-->>
                                                </div>
                                            @endif
                                        </td>
                                        <td>{{ $user->priority }}</td>
                                       <td> @if($user->status_id == 3)
                                                <button type="button" class="btn btn-round btn-danger"> {{ $user->status->name }} </button>
                                                @elseif($user->status_id == 4)
                                                <button type="button" class="btn btn-round btn-warning"> {{ $user->status->name }} </button>
                                                @elseif($user->status_id == 5)
                                                <button type="button" class="btn btn-round btn-primary"> {{ $user->status->name }} </button>
                                                @endif
                                        </td>
                                        <!--<td>{{ $user->subadmin->name }}</td>-->
                                        <td>{{ $user->user->name }}</td>
                                        <td>{{ $user->create }}</td>
                                        <td>
                                            <a class="btn btn-info"
                                               href="{{ route('complaint.show',$user->id) }}">Show</a>
                                            @can('subedit')
                                                <a class="btn btn-primary showModal"
                                                   href="#" data-id="{{ $user->id }}">Add response</a>
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="exampleModalLabel">Complaint Response</h4>
                    </div>
                    <div class="modal-body">
                        {!! Form::open(['method' => 'POST','accept-charset' => "UTF-8" ,'role' => 'form' ,
                           'enctype' => 'multipart/form-data' , 'data-parsley-validate' , 'id' => 'demo-form2',
                            'class' => 'form-horizontal form-label-left','route' => 'my.complaint.assign']) !!}

                        <input type="hidden" name="complaint_id" id="complaint_id" value="">
                        @csrf

                        <div class="form-group {{ ($errors->has('status_id')) ? 'has-error' : '' }}">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12" for="roles">Status <span
                                    class="required">*</span>
                            </label>
                            <div class="col-md-6 col-sm-6 col-xs-12">
                                {!! Form::select('status_id',$status,null, array('class' => 'select2_single form-control col-md-7 col-xs-12','required' =>'required')) !!}
                            </div>
                            {!! ($errors->has('status_id') ? $errors->first('status_id', '<p class="text-danger">:message</p>') : '') !!}
                        </div>


                        <div class="form-group {{ ($errors->has('response')) ? 'has-error' : '' }}">
                            <label class="control-label col-md-3 col-sm-3 col-xs-12" for="name">Response
                                <span
                                    class="required">*</span>
                            </label>
                            <div class="col-md-6 col-sm-6 col-xs-12">
                                {!! Form::textarea('response', null, array('placeholder' => 'Response','class' => 'form-control col-md-7 col-xs-12' , 'rows' => '3','required' =>'required')) !!}
                            </div>
                            {!! ($errors->has('response') ? $errors->first('response', '<p class="text-danger">:message</p>') : '') !!}
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function () {
            $('#datatable1').DataTable({
                "order": [[0, "desc"]]
            });

            $('.showModal').on('click', function () {
                var id = $(this).attr('data-id');
                $('#complaint_id').val(id)
                $('#exampleModal').modal('show');
            });

        });
    </script>
@endsection

