<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Petition extends Model
{
    use HasFactory;
    protected $fillable =[
        'title',
        'description',
        'category_id',
        'user_id',
        'status_id',
        'police_station',
        'tehsil',
        'district',
        'union_council',
    ];
    
    public function status()
    {
        return $this->belongsTo(Status::class)->withDefault();
    }

    public function category()
    {
        return $this->belongsTo(Category::class)->withDefault();
    }

    public function user()
    {
        return $this->belongsTo(User::class)->withDefault();
    }

    public function response(){
        return $this->hasMany(PetitionResponse::class);
    }

    public function vote(){
        return $this->hasMany(PetitionVote::class);
    }

    public function getCreateAttribute()
    {
        return $this->created_at->format('d-m-Y h:i a');
    }
}
