<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Spatie\Permission\Models\Role;
use DB;
use Hash;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Mail;
use Redirect;

class UserController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:list|create|edit|delete', ['only' => ['index', 'store']]);
        $this->middleware('permission:create', ['only' => ['create', 'store']]);
        $this->middleware('permission:edit|superuseredit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:delete', ['only' => ['destroy']]);
    }

    public function nmemberStatus(Request $request){
        if($request->complaint_id){
            $ids = explode(',',$request->complaint_id);
            foreach($ids as $id){
                $user = User::where('id',$id)->first();
                $email = $user->email;
                Mail::send('approval', ['approved'=>'true'], function ($message) use ($email) {
                    $message->to($email, evn('MAIL_FROM_NAME'))->subject
                    ('Account Approved');
                    $message->from(env('MAIL_FROM_ADDRESS'), evn('MAIL_FROM_NAME'));
                });
            }

            $update = User::whereIn('id',$ids)->update(['status'=>'3']);
            $update = User::whereIn('id',$ids)->update(['stepcompletion'=>'4']);
            return redirect()->back()
            ->with('success', 'User verified successfully');
        }else{
            return redirect()->back()
            ->with('danger', 'Try Again');
        }

        // dd($request->all());
    }

    public function subUser(Request $request)
    {
        $data = User::where('role','Sub Admin')->orderBy('id', 'DESC')->get();
        return view('users.subadmin', compact('data'));
    }

    public function superadminUser(Request $request)
    {
        $data = User::where('role','Super Admin')->orderBy('id', 'DESC')->get();
        return view('users.superadmin', compact('data'));
    }

    public function superuserUser(Request $request)
    {
        $data = User::where('role','Super User')->orderBy('id', 'DESC')->get();
        return view('users.superuser', compact('data'));
    }

    public function memberUser(Request $request)
    {
        $data = User::where('status',3)->orderBy('id', 'DESC')->get();
        return view('users.member', compact('data'));
    }

    public function nmemberUser(Request $request)
    {
        $data = User::where('status',4)->orderBy('id', 'DESC')->get();
        return view('users.nmember', compact('data'));
    }

    public function myUser(Request $request)
    {
        $data = User::where('recommended_by',auth()->user()->id)->orderBy('id', 'DESC')->get();
        return view('users.myuser', compact('data'));
    }

    public function index(Request $request)
    {
        $data = User::where('role','Admin')->orderBy('id', 'DESC')->get();
        return view('users.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = Role::pluck('name', 'name')->all();
        $users = User::pluck('name','id')->all();
        return view('users.create', compact('roles','users'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|same:confirm-password',
            'roles' => 'required',
        ]);

        $input = $request->all();
        $input['password'] = Hash::make($input['password']);
        $input['role'] = implode(',', $input['roles']);
        $input['type_of_disability'] = 'hello';
        $user = User::create($input);
        if($request->photo){
            $fileName = time().'.'.$request->photo->extension();
            $request->photo->move(public_path('assets/uploads'), $fileName);
            $user->photo = $fileName;
        }
        $user->father_name = $request->input('father_name');
        $user->dob = $request->input('dob');
        $user->doe = $request->input('doe');
        $user->gender = $request->input('gender');
        $user->id_no = $request->input('id_no');
        $user->permanent_address = $request->input('permanent_address');
        $user->mobile_no = $request->input('mobile_no');
        $user->tehsil = $request->input('tehsil');
        $user->district = $request->input('district');
        $user->union_council = $request->input('union_council');
        $user->disability = $request->input('disability');
        $user->type_of_disability = $request->input('type_of_disability');
        $user->police_station = $request->input('police_station');
        $user->recommended_by = $request->input('recommended_by');
        $user->save();
        $user->assignRole($request->input('roles'));
        return redirect()->back()
            ->with('success', 'User created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = User::find($id);
        return view('users.show', compact('user'));
    }


    public function myUserShow($id)
    {
        $user = User::where('id',$id)->where('recommended_by',auth()->user()->id)->first();
        return view('users.myuser_show', compact('user'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::find($id);
        $roles = Role::pluck('name', 'name')->all();
        $userRole = $user->roles->pluck('name', 'name')->all();
        $users = User::pluck('name','id')->all();

        return view('users.edit', compact('user', 'roles', 'userRole','users'));
    }


    public function myUserEdit($id)
    {
        $user = User::where('id',$id)->where('recommended_by',auth()->user()->id)->first();
        // $roles = Role::pluck('name', 'name')->all();
        // $userRole = $user->roles->pluck('name', 'name')->all();
        // $users = User::pluck('name','id')->all();

        return view('users.myuser_edit', compact('user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users,email,' . $id,
            'password' => 'same:confirm-password',
            'roles' => 'required',
            'photo' => 'mimes:jpeg,jpg,gif|max:2048',
        ]);

        $input = $request->all();
        if (!empty($input['password'])) {
            $input['password'] = Hash::make($input['password']);
        } else {
            $input = Arr::except($input, array('password'));
        }
        $input['role'] = implode(',', $request->input('roles'));

        $user = User::find($id);

        $user->update($input);

        if($request->photo){
            $fileName = time().'.'.$request->photo->extension();
            $request->photo->move(public_path('assets/uploads'), $fileName);
            $user->photo = $fileName;
        }
        $user->father_name = $request->input('father_name');
        $user->dob = $request->input('dob');
        $user->doe = $request->input('doe');
        $user->gender = $request->input('gender');
        $user->id_no = $request->input('id_no');
        $user->permanent_address = $request->input('permanent_address');
        $user->mobile_no = $request->input('mobile_no');
        $user->tehsil = $request->input('tehsil');
        $user->district = $request->input('district');
        $user->union_council = $request->input('union_council');
        $user->disability = $request->input('disability');
        $user->type_of_disability = $request->input('type_of_disability');
        $user->police_station = $request->input('police_station');
        $user->recommended_by = $request->input('recommended_by');
        $user->save();
        DB::table('model_has_roles')->where('model_id', $id)->delete();
        $user->assignRole($request->input('roles'));
        if(auth()->user()->role == 'Super user'){
             return redirect()->route('my.user')
            ->with('success', 'User updated successfully');
        }else{
            // dd(auth()->user()->role);
            return Redirect::back()
            ->with('success', 'User updated successfully');
        }



    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        User::find($id)->delete();
        return redirect()->route('users.index')
            ->with('success', 'User deleted successfully');
    }
}
