<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Survey;
use App\Models\SurveyVote;
use App\Models\Notification;
use App\Firebase;

class SurveyController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:list|create|edit|delete', ['only' => ['index','show']]);
        $this->middleware('permission:create', ['only' => ['create','store']]);
        $this->middleware('permission:edit', ['only' => ['edit','update']]);
        $this->middleware('permission:delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $data = Survey::orderBy('id', 'DESC')->get();
        return view('survey.index',compact('data'));
//            ->with('i', (request()->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('survey.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        request()->validate([
            'title' => 'required',
            'description' => 'required',
        ]);

        $input = $request->all();
        $input['user_id'] = auth()->user()->id;

        Survey::create($input);
        $token = '/topics/news';
            $title = $request->title;
            $body =  $request->description;
            $click_action = 'Survey';
            
            $token1 = '/topics/newsAndroid';
            $this->NotificationTopicSend($token1,$title,$body,$click_action,'android');
            $this->NotificationTopicSend($token,$title,$body,$click_action,'ios');
            
           
        return redirect()->route('survey.index')
            ->with('success','Survey created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Survey  $survey
     * @return \Illuminate\Http\Response
     */
    public function show(Survey $survey)
    {
        $yes = SurveyVote::where('survey_id',$survey->id)->where('vote',1)->count();
        $no = SurveyVote::where('survey_id',$survey->id)->where('vote',0)->count();
        return view('survey.show',compact('survey','yes','no'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Survey  $survey
     * @return \Illuminate\Http\Response
     */
    public function edit(Survey $survey)
    {
        return view('survey.edit',compact('survey'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Survey  $survey
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Survey $survey)
    {
        request()->validate([
            'title' => 'required',
            'description' => 'required',
        ]);

        $input = $request->all();
        $input['user_id'] = auth()->user()->id;
        $survey->update($input);

        return redirect()->route('survey.index')
            ->with('success','Survey updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Survey  $survey
     * @return \Illuminate\Http\Response
     */
    public function destroy(Survey $survey)
    {
        $survey->delete();
        return redirect()->route('survey.index')
            ->with('success','Survey deleted successfully');
    }


}
