<?php

namespace App\Http\Controllers;

use App\Models\Place;
use Illuminate\Http\Request;

class PlaceController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:list|create|edit|delete', ['only' => ['index','show']]);
        $this->middleware('permission:create', ['only' => ['create','store']]);
        $this->middleware('permission:edit', ['only' => ['edit','update']]);
        $this->middleware('permission:delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $data = Place::orderBy('id', 'DESC')->get();
        return view('place.index',compact('data'));
//            ->with('i', (request()->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('place.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        request()->validate([
            'place' => 'required',
            'union_council' => 'required',
            'police_station' => 'required',
            'tehsil' => 'required',
        ]);

        $create = Place::create($request->all());

        if($create){
            return redirect()->route('place.index')
                ->with('success','Place created successfully.');
        }
        
        
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Announcement  $announcement
     * @return \Illuminate\Http\Response
     */
    public function show(Place $place)
    {
        return view('place.show',compact('place'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Announcement  $survey
     * @return \Illuminate\Http\Response
     */
    public function edit(Place $place)
    {
        return view('place.edit',compact('place'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Announcement  $announcement
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Place $place)
    {
        request()->validate([
            'place' => 'required',
            'union_council' => 'required',
            'police_station' => 'required',
            'tehsil' => 'required',
        ]);

        $place->update($request->all());

        return redirect()->route('place.index')
            ->with('success','Place updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Announcement  $announcement
     * @return \Illuminate\Http\Response
     */
    public function destroy(Place $place)
    {
        $place->delete();
        return redirect()->route('place.index')
            ->with('success','Place deleted successfully');
    }
}
