<?php

namespace App\Http\Controllers;

use App\Models\Petition;
use App\Models\PetitionResponse;
use App\Models\Status;
use App\Models\PetitionVote;
use App\Models\User;


use Illuminate\Http\Request;

class PetitionController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:list|create|edit|delete', ['only' => ['index', 'show']]);
        $this->middleware('permission:create', ['only' => ['create', 'store']]);
        $this->middleware('permission:edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $priority = ['High' => 'High','Medium' => 'Medium','Low' => 'Low'];
        $status = Status::where('name', '!=', 'Rejected')->pluck('name', 'id');
        $data = Petition::orderBy('id', 'DESC')->get();
        return view('petition.index', compact('data', 'status','priority'));
//            ->with('i', (request()->input('page', 1) - 1) * 5);
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    { 
        $complaint = Petition::find($id);
        $yes = PetitionVote::where('petition_id',$complaint->id)->where('vote',1)->count();
        $no = PetitionVote::where('petition_id',$complaint->id)->where('vote',0)->count();
        return view('petition.show', compact('complaint','yes','no'));
    }

    public function destroy($id)
    { 
        $idinfo = explode('_',$id);
        $id = $idinfo[0];
        $st = $idinfo[1];
        if($st == 'a')
        {
            $c = Petition::find($id)->update(['status_id' =>1]);
            if($c)
            {
                $pinfo = Petition::where('id',$id)->first();
                $token = '/topics/news';
                $title = $pinfo->title;
                $body =  $pinfo->description;
                $click_action = 'Petition';
                $token1 = '/topics/newsAndroid';
                $this->NotificationTopicSend($token1,$title,$body,$click_action,'android');
                $this->NotificationTopicSend($token,$title,$body,$click_action,'ios');
                $up = PetitionResponse::insert([
                    'petition_id' => $id,
                    'response' => 'Admin approved petition',
                    'response_by' => auth()->user()->id
                ]);
                return redirect()->route('petition.index')
                    ->with('success', 'Petition approved successfully');
                } else {
                return redirect()->route('petition.index')
                    ->with('delete', 'Try Again');
            }
        }
        else if($st == 'd'){
            $c = Petition::find($id)->update(['status_id' => 6]);
            if ($c) {
                $up = PetitionResponse::insert([
                    'petition_id' => $id,
                    'response' => 'Admin rejected petition',
                    'response_by' => auth()->user()->id
                ]);
                
                $pinfo = Petition::where('id',$id)->first();
                if($pinfo){
                    $user = User::where('id',$pinfo->user_id)->first();
                    $token = $user->firebase_token; 
                    $device = $user->os; 
                    $title = 'Petition rejected ';
                    $body =  'Admin rejected petition';
                    $click_action = '';
                    $this->NotificationSend($token,$user->id,$title,$body,$click_action,$device);
                }
                
               
                return redirect()->route('petition.index')
                    ->with('success', 'Petition rejected successfully');
            } else {
                return redirect()->route('petition.index')
                    ->with('delete', 'Try Again');
            }
        }
    
        
       
    }

  
}
