<?php

namespace App\Http\Controllers;

use App\Models\Memoir;
use Illuminate\Http\Request;

class MemoirController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:list|create|edit|delete', ['only' => ['index','show']]);
        $this->middleware('permission:create', ['only' => ['create','store']]);
        $this->middleware('permission:edit', ['only' => ['edit','update']]);
        $this->middleware('permission:delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $data = Memoir::orderBy('id', 'DESC')->get();
        return view('memoir.index',compact('data'));
//            ->with('i', (request()->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('memoir.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        request()->validate([
            'title' => 'required',
            'description' => 'required',
        ]);
        
        $input = $request->all();
        
        if($request->image){
            $fileName = time().'.'.$request->image->extension();
            $request->image->move(public_path('assets/uploads'), $fileName);
            $input['image'] = $fileName;
        }
        else{

            $input['image'] = 'logo.jpg';
        }
        
        $data = Memoir::create($input);
        
        if($data){
            $token = '/topics/news';
            $title = $request->title;
            $body =  $request->description;
            $click_action = 'Condolences';
            $token1 = '/topics/newsAndroid';
            $this->NotificationTopicSend($token1,$title,$body,$click_action,'android');
            $this->NotificationTopicSend($token,$title,$body,$click_action,'ios');
        }

        return redirect()->route('memoir.index')
            ->with('success','Memoir created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Announcement  $memoir
     * @return \Illuminate\Http\Response
     */
    public function show(Memoir $memoir)
    {
        return view('memoir.show',compact('memoir'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Announcement  $survey
     * @return \Illuminate\Http\Response
     */
    public function edit(Memoir $memoir)
    {
        return view('memoir.edit',compact('memoir'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Announcement  $announcement
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Memoir $memoir)
    {
        request()->validate([
            'title' => 'required',
            'description' => 'required',
        ]);
        
        $input = $request->all();
        
        if($request->image){
            $fileName = time().'.'.$request->image->extension();
            $request->image->move(public_path('assets/uploads'), $fileName);
            $input['image'] = $fileName;
        }
       

        $memoir->update($input);

        return redirect()->route('memoir.index')
            ->with('success','Memoir updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Announcement  $announcement
     * @return \Illuminate\Http\Response
     */
    public function destroy(Memoir $memoir)
    {
        $memoir->delete();
        return redirect()->route('memoir.index')
            ->with('success','Memoir deleted successfully');
    }
}
