<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Survey;
use App\Models\Complaint;
use App\Models\Petition;
use App\Models\SurveyVote;
use App\Models\Category;
use App\Models\Status;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {


        $total_user = User::all()->count();
        $user_male = User::where('gender' ,'Male')->count();
        $user_female = User::where('gender' ,'female')->count();

        $subuser = User::where('role' ,'Sub Admin')->count();
        $superuser = User::where('role' ,'Super user')->count();
        $member = User::where('role' ,'Member')->count();

        $categoires = Category::all();
        $catgory = [];
        foreach($categoires as $cat){
            $cats = [];
            $cats['id'] = $cat->name;
            $cats['count'] = Complaint::where('category_id',$cat->id)->count();
            $catgory[] = $cats;
        }


        $statuses = Status::all();
        $status = [];
        foreach($statuses as $st){
            $sta = [];
            $sta['id'] = $st->name;
            $sta['count'] = Complaint::where('status_id',$st->id)->count();
            $status[] = $sta;
        }

        $survey = Survey::has('vote')->get()->count();
        $complaint = Complaint::all()->count();
        $petition = Petition::has('vote')->get()->count();
        $top_survey  =  Survey::orderByRaw("CAST(vote_yes as UNSIGNED) DESC")->limit(10)->has('vote')->get();
        $total_survey = [];
        foreach($top_survey as $s){
            $array = [];
            $t = $s->vote->count();
            $array['id'] = $s->id;
            $array['title'] = "$s->title Total($t)";
            $array['total_vote'] = $s->vote->count();
            $array['vote_yes'] = SurveyVote::where('survey_id',$s->id)->where('vote',1)->count();
            $array['Vote_no'] = SurveyVote::where('survey_id',$s->id)->where('vote',0)->count();
            $total_survey[] = $array;
        }

        $top_petition  =  Petition::orderByRaw("CAST(vote_yes as UNSIGNED) DESC")->limit(10)->has('vote')->get();
        $total_petition = [];
        foreach($top_petition as $s){
            $array1 = [];
            $t = $s->vote->count();
            $array1['id'] = $s->id;
            $array1['title'] = "$s->title Total($t)";
            $array1['total_vote'] = $s->vote->count();
            $total_petition[] = $array1;
        }

        $all = Complaint::groupBy('district')->get();
        $district_complaint = [];
        foreach($all as $d_c){
            $ar = [];
            $ar['district'] = $d_c->district;
            $ar['count'] =  Complaint::where('district',$d_c->district)->count();
            $tehsils =   Complaint::where('district',$d_c->district)->groupBy('tehsil')->get();
            $data = [];
            foreach($tehsils as $teh){
                $te = [];
                $t = Complaint::where('district',$d_c->district)->where('tehsil',$teh->tehsil)->first();
                $te['name'] = $t->tehsil;
                $te['count'] = Complaint::where('district',$d_c->district)->where('tehsil',$teh->tehsil)->count();
                $data[] = $te;
            }
            $ar['data'] = $data;
            $district_complaint[] = $ar;
        }

        $union_council = [];
        foreach($all as $d_c){
            $ar = [];
            $ar['district'] = $d_c->district;
            $ar['count'] =  Complaint::where('district',$d_c->district)->count();
            $tehsils =   Complaint::where('district',$d_c->district)->groupBy('union_council')->get();
            $data = [];
            foreach($tehsils as $teh){
                $te = [];
                $t = Complaint::where('district',$d_c->district)->where('union_council',$teh->union_council)->first();
                $te['name'] = $t->union_council;
                $te['count'] = Complaint::where('district',$d_c->district)->where('union_council',$teh->union_council)->count();
                $data[] = $te;
            }
            $ar['data'] = $data;
            $union_council[] = $ar;
        }

        $police_station = [];
        foreach($all as $d_c){
            $ar = [];
            $ar['district'] = $d_c->district;
            $ar['count'] =  Complaint::where('district',$d_c->district)->count();
            $tehsils =   Complaint::where('district',$d_c->district)->groupBy('police_station')->get();
            $data = [];
            foreach($tehsils as $teh){
                $te = [];
                $t = Complaint::where('district',$d_c->district)->where('police_station',$teh->police_station)->first();
                $te['name'] = $t->police_station;
                $te['count'] = Complaint::where('district',$d_c->district)->where('police_station',$teh->police_station)->count();
                $data[] = $te;
            }
            $ar['data'] = $data;
            $police_station[] = $ar;
        }


        return view('home')->with(compact('total_user','user_male','user_female','survey','district_complaint','subuser','superuser','member','catgory',
        'status','complaint','petition','total_survey','total_petition','union_council','police_station'));
    }

    // public function privacypolicy()
    // {
    //     return view('privacypolicy');
    // }

    // public function cookiepolicy()
    // {
    //     return view('cookiespolicy');
    // }
    // public function contactus()
    // {
    //     return view('contact_us');
    // }
}
