<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Dairy;
use App\Models\DairyResponse;

class DairyController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:list|create|edit|delete', ['only' => ['index', 'store']]);
        $this->middleware('permission:create', ['only' => ['create', 'store']]);
        $this->middleware('permission:edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:delete', ['only' => ['destroy']]); 
    }
    
    public function index()
    {
        $priority = ['Low' => 'Low','Medium' => 'Medium','High' => 'High'];
        $data = Dairy::where('user_id',auth()->user()->id)->orderBy('date_time', 'DESC')->get();
        return view('dairy.index',compact('data','priority'));
//            ->with('i', (request()->input('page', 1) - 1) * 5);
    }

    public function create()
    {
        $priority = ['Low' => 'Low','Medium' => 'Medium','High' => 'High'];
        return view('dairy.create' , compact('priority'));
    }
    
    public function dairyResponse(Request $request)
    {
    //   dd($request->all());
        request()->validate([
            'response' => 'required',
        ]);
        
        $input = $request->all();
        $input['status_id'] = '';
        $input['user_by'] = auth()->user()->id;
        DairyResponse::create($input);
        

        return redirect()->route('dairy.index')
            ->with('success','Dairy response created successfully.');
    }
    
    public function store(Request $request)
    {
//        dd($request->all());
        request()->validate([
            'title' => 'required',
            'description' => 'required',
            'images' => 'mimes:jpeg,jpg,gif|max:2048',
        ]);

        $input = $request->all();
        
        if($request->image){
            $fileName = time().'.'.$request->image->extension();
            $request->image->move(public_path('assets/uploads'), $fileName);
            $input['image'] = $fileName;
        }
        
       
        $input['status'] = 'Pending';
        $input['user_id'] = auth()->user()->id;
        $data = Dairy::create($input);
        
        if($data){
            $token = '/topics/news';
            $title = $request->title;
            $body =  $request->description;
            $click_action = 'Dairy';
             $token1 = '/topics/newsAndroid';
            $this->NotificationTopicSend($token1,$title,$body,$click_action,'android');
            $this->NotificationTopicSend($token,$title,$body,$click_action,'ios');
        }
        return redirect()->route('dairy.index')
            ->with('success','Dairy created successfully.');
    }
    
    public function edit(Dairy $dairy)
    {
        $priority = ['Low' => 'Low','Medium' => 'Medium','High' => 'High'];
        return view('dairy.edit',compact('dairy','priority'));
    }
    
    public function update(Request $request, Dairy $dairy)
    {
        request()->validate([
            'title' => 'required',
            'description' => 'required',
            'images' => 'mimes:jpeg,jpg,gif|max:2048',
        ]);
        
        $input = $request->all();
        
        if($request->image){
            $fileName = time().'.'.$request->image->extension();
            $request->image->move(public_path('assets/uploads'), $fileName);
            $input['image'] = $fileName;
        }
        
        $input['user_id'] = auth()->user()->id;
        $dairy->update($input);

        return redirect()->route('dairy.index')
            ->with('success','Dairy updated successfully');
    }
    
    public function destroy($id)
    {
        Dairy::find($id)->delete();
        return redirect()->route('dairy.index')
            ->with('success', 'Dairy deleted successfully');
    }
    
    public function show($id)
    {
        $complaint = Dairy::find($id);
        return view('dairy.show', compact('complaint'));
    }
}
