<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ContactUs;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class ContactUsController extends Controller
{
    public function index()
    {
        $data = ContactUs::orderBy('id','DESC')->get();
        return view('contactus.index',compact('data'));

    }

    public function store(Request $request)
    {
        $request->validate([
            'contact_id' => 'required',
            'role' => 'required',
        ]);

        // Find the contact record
        $contact = ContactUs::findOrFail($request->input('contact_id'));
        if ($request->input('role') == 'Admin') {
            // Create an admin user
            $user = User::create([
                'name' => $contact->name,
                'email' => $contact->email,
                'password' => Hash::make('12345678'),
                'role' => 'Admin',
                'device_id' => $contact->device_id,
                'status' => 3,
            ]);

        $contact->usertype = $request->input('role');
        $contact->save();
            

            // Send email to the user
            //Mail::to($user->email)->send(new RoleAssignedMail($user, 'admin'));

            // Redirect or respond as needed
            return redirect()->route('contactus.index')->with('success', 'Admin user created successfully!');
        } else {
            // If the role is not "admin," no action is performed
            return redirect()->route('contactus.index')->with('success', 'No action performed.');
        }
    }

    public function destroy($id)
    {
        // Find the contact record
        $contact = ContactUs::findOrFail($id);

        // Delete the record
        $contact->delete();

        // Redirect or respond as needed
        return redirect()->route('contactus.index')->with('success', 'Contact record deleted successfully!');
    }
}
