<?php

namespace App\Http\Controllers;

use App\Models\Complaint;
use App\Models\ComplaintResponse;
use App\Models\Status;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Firebase;
use App\Models\Notification;
use Illuminate\Support\Facades\Mail;

class ComplaintController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:list|create|edit|delete|sublist', ['only' => ['index', 'show']]);
        $this->middleware('permission:create', ['only' => ['create', 'store']]);
        $this->middleware('permission:edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:delete', ['only' => ['destroy']]);
    }

    public function myComplaintAssign(Request $request)
    {

        $c = Complaint::find($request->complaint_id)->update([
            'status_id' => $request->status_id,
        ]);
        if ($c) {

            $up = ComplaintResponse::insert([
                'complaint_id' => $request->complaint_id,
                'response' => $request->response,
                'response_by' => auth()->user()->id,
                'created_at' => date('Y-m-d H:i:s')
            ]);
            //Notification Sent
            $cinfo = Complaint::where('id',$request->complaint_id)->get();
            $uinfo = User::where('id',$cinfo[0]['user_id'])->get();
           // echo "<pre>"; print_r($uinfo); echo "</pre>";
            $firebasetoken = $uinfo[0]['firebase_token'];
            $device = $uinfo[0]['os'];
            //echo $firebase;


            if($request->status_id == 4){
                $status = 'Complaint InReview';
            }else{
                $status = 'Complaint Resolved';
            }
            $firebase = new Firebase();
            $data =  $firebase->push_notification_send($firebasetoken,$status,$request->response,$status,$device);

            $resultnotification = json_decode($data);
            $notification = new Notification();
            $notification->title = $status;
            $notification->action = $status;
            $notification->body = $request->response;
            $notification->user_id = $cinfo[0]['user_id'];
            $notification->created_at = date('Y-m-d H:i:s');
            if($resultnotification->success == 1){
                $notification->status = 1;
                $notification->messageid =  $resultnotification->results[0]->message_id;
            }else{ $notification->status = 0;
                $notification->errormsg = $resultnotification->results[0]->error;
            }

            $notification->save();

            //End Notification
            return redirect()->route('my.complaint')
                ->with('success', 'Complaint response successfully inserted');
        } else {
            return redirect()->route('my.complaint')
                ->with('delete', 'Try Again');
        }

    }

    public function complaintAssign(Request $request)
    {

        $c = Complaint::find($request->complaint_id)->update([
            'priority' => $request->priority,
            'status_id' => $request->status_id,
            'sub_admin_id' => $request->sub_admin_id,
        ]);
        if ($c) {

            $up = ComplaintResponse::insert([
                'complaint_id' => $request->complaint_id,
                'response' => $request->response,
                'response_by' => auth()->user()->id,
                'created_at' => date('Y-m-d H:i:s')
            ]);

            //Notification Sent
            $cinfo = Complaint::where('id',$request->complaint_id)->get();
            $uinfo = User::where('id',$cinfo[0]['sub_admin_id'])->get();
            $cuinfo = User::where('id',$cinfo[0]->user_id)->first();

            if($cuinfo){
                $token = $cuinfo->firebase_token;
                $device = $cuinfo->os;
                $title = 'Complaint Pending';
                $body =  'Your complaint has been assign to our team member';
                $click_action = 'Complaint Pending';
               // $this->NotificationSend($token,$cuinfo->id,$title,$body,$click_action,$device);
            }

            $email = $uinfo[0]->email;
            Mail::send('complaint_assign', ['assign'=>'true'], function ($message) use ($email) {
                $message->to($email, evn('MAIL_FROM_NAME'))->subject
                ('Complaint Assign');
                $message->from(env('MAIL_FROM_ADDRESS'), evn('MAIL_FROM_NAME'));
            });

        //    // echo "<pre>"; print_r($uinfo); echo "</pre>";
           // $firebasetoken = $uinfo[0]['firebase_token'];
          //  echo $firebasetoken;

            // $firebase = new Firebase();
            // $data =  $firebase->push_notification_send($firebasetoken,'Complaint Status',$request->response,'Complaint','');
            // echo "<pre>"; print_r($data); echo "</pre>";
            // exit;

            // $resultnotification = json_decode($data);
            //     $notification = new Notification();
            //     $notification->title = 'Complaint Status';
            //     $notification->body = $request->response;
            //     $notification->user_id = $cinfo[0]['user_id'];
            //     $notification->created_at = date('Y-m-d H:i:s');
            //     if($resultnotification->success == 1){
            //         $notification->status = 1;
            //         $notification->messageid =  $resultnotification->results[0]->message_id;
            //     }else{ $notification->status = 0;
            //         $notification->errormsg = $resultnotification->results[0]->error;
            //     }
            //     $notification->save();

            //End Notification

            return redirect()->route('complaint.index')
                ->with('success', 'Complaint response successfully inserted');
        } else {
            return redirect()->route('complaint.index')
                ->with('delete', 'Try Again');
        }

    }

    public function index()
    {
        $priority = ['Low' => 'Low','Medium' => 'Medium','High' => 'High'];
        $users = User::where('role', 'Sub Admin')->pluck('name', 'id');
        $status = Status::whereNotIn('name',['Rejected'])->pluck('name', 'id');
        $data = Complaint::orderBy('id', 'DESC')->get();

        $categoires = Category::all();
        $catgory = [];
        foreach($categoires as $cat){
            $cats = [];
            $cats['id'] = $cat->name;
            $cats['count'] = Complaint::where('category_id',$cat->id)->count();
            $catgory[] = $cats;
        }


        $statuses = Status::all();
        $status_all = [];
        foreach($statuses as $st){
            $sta = [];
            $sta['id'] = $st->name;
            $sta['count'] = Complaint::where('status_id',$st->id)->count();
            $status_all[] = $sta;
        }

        return view('complaint.index', compact('data', 'users', 'status','priority','catgory','status_all'));
//            ->with('i', (request()->input('page', 1) - 1) * 5);
    }

    public function myComplaint()
    {
        $priority = ['Low' => 'Low','Medium' => 'Medium','High' => 'High'];
        $users = User::where('role', 'Sub Admin')->pluck('name', 'id');
        $status = Status::whereNotIn('name',['Rejected','Submitted','pending'])->pluck('name', 'id');
        $data = Complaint::where('sub_admin_id',auth()->user()->id)->orderBy('id', 'DESC')->get();
        return view('complaint.myindex', compact('data', 'users', 'status','priority'));
//            ->with('i', (request()->input('page', 1) - 1) * 5);
    }
    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $complaint = Complaint::find($id);
        return view('complaint.show', compact('complaint'));
    }

    public function destroy($id)
    {
        $c = Complaint::find($id)->update(['status_id' => 6]);
        if ($c) {

            $up = ComplaintResponse::insert([
                'complaint_id' => $id,
                'response' => 'Admin rejected complaint',
                'response_by' => auth()->user()->id
            ]);

             //Notification Sent
             $cinfo = Complaint::where('id',$id)->get();
             $uinfo = User::where('id',$cinfo[0]['user_id'])->get();
             $firebasetoken = $uinfo[0]['firebase_token'];
             $device = $uinfo[0]['os'];
             $firebase = new Firebase();
             $data =  $firebase->push_notification_send($firebasetoken,'Complaint Rejected','Your complaint has been rejected.','Complaint Rejected',$device);
             $resultnotification = json_decode($data);

                 $notification = new Notification();
                 $notification->title = 'Complaint Rejected';
                 $notification->action = 'Complaint Rejected';
                 $notification->body =  'Your compalint has been rejected';
                 $notification->user_id = $cinfo[0]['user_id'];
                 $notification->created_at = date('Y-m-d H:i:s');
                 if($resultnotification->success == 1){
                    $notification->status = 1;
                    $notification->messageid =  $resultnotification->results[0]->message_id;
                }else{ $notification->status = 0;
                    $notification->errormsg = $resultnotification->results[0]->error;
                }
                $notification->save();

             //End Notification
            return redirect()->route('complaint.index')
                ->with('success', 'Complaint rejected successfully');
        } else {
            return redirect()->route('complaint.index')
                ->with('delete', 'Try Again');
        }
    }
}
