<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Redirect;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function privacypolicy()
    {
        return view('privacypolicy');
    }

    public function cookiepolicy()
    {
        return view('cookiespolicy');
    }
    public function contactus()
    {
        return view('contact_us');
    }

    public function postContact(Request $request)
    {
       // dd($request);
        $data = [];
        $data[] = $request->name;
        $data[] = $request->email;
        $email = $request->email;
        $data[] = $request->phone;
        $data[] = $request->msg;


        Mail::send('contact', ['data' => $data], function ($message) use ($email) {

            $message->to('info@sophianaqvi.listen2me.biz', 'Sophia Naqvi')->subject
            ('Contact Us');
            $message->from('info@sophianaqvi.listen2me.biz', 'Sophia Naqvi');
            //$message->cc('tehsinzaidi@gmail.com');
        });

        if (Mail::failures()) {
            return Redirect::back()->with('delete', 'Try Again');
        }

        return Redirect::back()->with('success', 'Thank You! Your message has been sent successfully.');


    }

    public function jointhefight(Request $request)
    {
        echo 'Join the fight';
    }
    public function support(Request $request)
    {
        echo "support";
    }

}
