<?php

namespace App\Http\Controllers;

use App\Models\Announcement;
use Illuminate\Http\Request;

class AnnouncementController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:list|create|edit|delete', ['only' => ['index','show']]);
        $this->middleware('permission:create', ['only' => ['create','store']]);
        $this->middleware('permission:edit', ['only' => ['edit','update']]);
        $this->middleware('permission:delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $data = Announcement::orderBy('id', 'DESC')->get();
        return view('announcement.index',compact('data'));
//            ->with('i', (request()->input('page', 1) - 1) * 5);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('announcement.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        request()->validate([
            'title' => 'required',
            'description' => 'required',
        ]);

        $create = Announcement::create($request->all());

        if($create){
            $token = '/topics/news';
            $title = $request->title;
            $body =  $request->description;
            $click_action = 'Announcement';
            $token1 = '/topics/newsAndroid';
            // $this->NotificationTopicAndroidSend($token1,$title,$body,$click_action);
            $this->NotificationTopicSend($token1,$title,$body,$click_action,'');
            $this->NotificationTopicSend($token,$title,$body,$click_action,'');

            return redirect()->route('announcement.index')
                ->with('success','Announcement created successfully.');
        }


    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Announcement  $announcement
     * @return \Illuminate\Http\Response
     */
    public function show(Announcement $announcement)
    {
        return view('announcement.show',compact('announcement'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Announcement  $survey
     * @return \Illuminate\Http\Response
     */
    public function edit(Announcement $announcement)
    {
        return view('announcement.edit',compact('announcement'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Announcement  $announcement
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Announcement $announcement)
    {
        request()->validate([
            'title' => 'required',
            'description' => 'required',
        ]);

        $announcement->update($request->all());
        if($request->status=='Active')
        {
            $token = '/topics/news';
            $title = $request->title;
            $body =  $request->description;
            $click_action = 'Announcement';
            $token1 = '/topics/newsAndroid';
            $this->NotificationTopicSend($token1,$title,$body,$click_action,'android');
            $this->NotificationTopicSend($token,$title,$body,$click_action,'ios');
        }

        return redirect()->route('announcement.index')
            ->with('success','Announcement updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Announcement  $announcement
     * @return \Illuminate\Http\Response
     */
    public function destroy(Announcement $announcement)
    {
        $announcement->delete();
        return redirect()->route('announcement.index')
            ->with('success','Announcement deleted successfully');
    }
}
