<?php

namespace App\Http\Controllers;

use App\Models\AboutMe;
use Illuminate\Http\Request;


class AboutMeController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:list|create|edit|delete', ['only' => ['index','show']]);
        $this->middleware('permission:create', ['only' => ['create','store']]);
        $this->middleware('permission:edit', ['only' => ['edit','update']]);
        $this->middleware('permission:delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $data = AboutMe::orderBy('id', 'DESC')->get();
        return view('aboutme.index',compact('data'));
//            ->with('i', (request()->input('page', 1) - 1) * 5);
    }

    public function create()
    {
        return view('aboutme.create');
    }

    public function store(Request $request)
    {
//        dd($request->all());
        request()->validate([
            'about_me' => 'required',
        ]);

        $input = $request->all();

        AboutMe::create($input);

        return redirect()->route('aboutme.index')
            ->with('success','About Me created successfully.');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\AboutMe  $aboutme
     * @return \Illuminate\Http\Response
     */
    public function edit(AboutMe $aboutme)
    {
        return view('aboutme.edit',compact('aboutme'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\AboutMe  $aboutme
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, AboutMe $aboutme)
    {
        request()->validate([
            'about_me' => 'required',
        ]);

        $input = $request->all();

        $data = $aboutme->update($input);
        if($data){
            $token = '/topics/news';
            $title = 'About Me';
            $body =  $request->about_me;
            $click_action = 'About Me';
            $token1 = '/topics/newsAndroid';
            $this->NotificationTopicSend($token1,$title,$body,$click_action,'android');
            $this->NotificationTopicSend($token,$title,$body,$click_action,'ios');
        }

        return redirect()->route('aboutme.index')
            ->with('success','About Me updated successfully');
    }

}
