<?php

namespace App;

class Firebase
{

    /**
     * Sending push message to single user by Firebase Registration ID
     * @param $to
     * @param $message
     *
     * @return bool|string
     */
    public function send($to, $message)
    {

        $fields = array(
            'to' => $to,
            'data' => $message,
        );
//        dd($fields);

        return $this->sendPushNotification($fields);
    }

    /**
     * Sending message to a topic by topic name
     * @param $to
     * @param $message
     *
     * @return bool|string
     */
    public function sendToTopic($to, $message)
    {
        $fields = array(
            'to' => '/topics/' . $to,
            'data' => $message,
        );

        return $this->sendPushNotification($fields);
    }

    /**
     * Sending push message to multiple users by firebase registration ids
     * @param $registration_ids
     * @param $message
     *
     * @return bool|string
     */
    public function sendMultiple($registration_ids, $message)
    {
        $fields = array(
            'to' => $registration_ids,
            'data' => $message,
        );

        return $this->sendPushNotification($fields);
    }

    /**
     * CURL request to firebase servers
     * @param $fields
     *
     * @return bool|string
     */
    private function sendPushNotification($fields)
    {

        // Set POST variables
        $url = 'https://fcm.googleapis.com/fcm/send';

        $key = "AAAA0dgJxQ4:APA91bFVJlkMByKefoqAdfmxmD7UiLWFNaT08QRgP9Zb8XCbzHV_No8X3rrkrbyJ13s88Uz2X92Lav8QkCzHoBI7VXjErJMK7szJapRUnzHTEAG2vxQe3MUM9zVgUAqZGJR93otPei1s";

        $headers = array(
            'Authorization: key=' . $key,
            'Content-Type: application/json'
        );

        // Open connection
        $ch = curl_init();

        // Set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_URL, $url);

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Disabling SSL Certificate support temporarly
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

        // Execute post
        $result = curl_exec($ch);

        if ($result === false) {
            die('Curl failed: ' . curl_error($ch));
        }

        // Close connection
        curl_close($ch);

        return $result;
    }

    function push_notification_send($deviceTokens, $title, $body,$click_action , $device)
	{
	   // $deviceTokens ="fUKejaHBRDGd5ksLP62D8E:APA91bF_BkOtIzZYHYcyWDxoVI9TpTZhpLZpzQSET21d9BmJ8Qwdge-CrD3DzCyTH4RjZ1rv1Spa3LMNLxszyLetKtqL0Jcw7otQzdC8K4T3oc7tyzeOdiNfJQyQzGgGk2wi2FSwZ_80";

		$apiKey =  "AAAA0dgJxQ4:APA91bFVJlkMByKefoqAdfmxmD7UiLWFNaT08QRgP9Zb8XCbzHV_No8X3rrkrbyJ13s88Uz2X92Lav8QkCzHoBI7VXjErJMK7szJapRUnzHTEAG2vxQe3MUM9zVgUAqZGJR93otPei1s";

		$message = array(
			'title' => $title,
			'body' => $body,
            'action' => $click_action,
			'sound' => 'default'
		);

		$url = 'https://fcm.googleapis.com/fcm/send';
		
		if(is_array($deviceTokens) && sizeof($deviceTokens) > 0){
			$deviceTokens = array_values(array_filter($deviceTokens));			
			$numTokens = count($deviceTokens);
			echo $numTokens;
			if($numTokens == 1){
			    
    			if($device == 'ios'){
                    $fields = array(
    					'to' => $deviceTokens[0],
    					'data' => $message,
    					'notification' => $message,
    				);
                }else{
                    $fields = array(
    					'to' => $deviceTokens[0],
    					'data' => $message,
    				// 	'notification' => $message,
    				);
                }
            
				
			}else if($numTokens > 1){
			    if($device == 'ios'){
                    $fields = array(
    					'registration_ids' => $deviceTokens,
    					'data' => $message,
    					'notification' => $message,
    				);
                }else{
                     $fields = array(
    					'registration_ids' => $deviceTokens,
    					'data' => $message,
    				// 	'notification' => $message,
    				);
                }
                
				
			}
		}else if(isset($deviceTokens) && !empty($deviceTokens)){
		        if($device == 'ios'){
                    $fields = array(
    					'to' => $deviceTokens,
    					'data' => $message,
    					'notification' => $message,
			    	);
                }else{
                    $fields = array(
    					'to' => $deviceTokens,
    					'data' => $message,
    				// 	'notification' => $message,
				    );
                }
                
			
		} else {
			return "Device Token Not FOund";
		}
		
		$headers = array(
			'Authorization: key=' . $apiKey,
			'Content-Type: application/json',
		);

		$ch = curl_init($url);

		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

		$result1 = curl_exec($ch);
		curl_close($ch);
		
		return $result1;
		
	}


    function sendNotificationToCommunity($token, $title, $body, $click_action) {
		$apiKey =  "AAAA0dgJxQ4:APA91bFVJlkMByKefoqAdfmxmD7UiLWFNaT08QRgP9Zb8XCbzHV_No8X3rrkrbyJ13s88Uz2X92Lav8QkCzHoBI7VXjErJMK7szJapRUnzHTEAG2vxQe3MUM9zVgUAqZGJR93otPei1s";
		$url = 'https://fcm.googleapis.com/fcm/send';
		
		$fields = array (
			"to" => $token,
			"collapse_key" => "collapse",
			 "priority" => "high",
			 'notification' => array(
				"click_action" =>$click_action,
				"title"=> $title,
				 "body" => $body
				),
			'data' => array (
				"title"=> $title,
				"body" => $body,
				"notifytype" => $click_action
			)
		);
			
		$headers = array(
			'Content-Type:application/json',
			'Authorization:key='.$apiKey
		);
					
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
		$result = curl_exec($ch);
		if ($result === FALSE) {
			//die('FCM Send Error: ' . curl_error($ch));
		}
		curl_close($ch);
}

}
